package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{ProcessingLocalPath, S3Uri}
import scala.jdk.CollectionConverters._
final case class ProcessingS3Input(
    s3Uri: S3Uri,
    localPath: Optional[ProcessingLocalPath] = Optional.Absent,
    s3DataType: zio.aws.sagemaker.model.ProcessingS3DataType,
    s3InputMode: Optional[zio.aws.sagemaker.model.ProcessingS3InputMode] =
      Optional.Absent,
    s3DataDistributionType: Optional[
      zio.aws.sagemaker.model.ProcessingS3DataDistributionType
    ] = Optional.Absent,
    s3CompressionType: Optional[
      zio.aws.sagemaker.model.ProcessingS3CompressionType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProcessingS3Input = {
    import ProcessingS3Input.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProcessingS3Input
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .optionallyWith(
        localPath.map(value =>
          ProcessingLocalPath.unwrap(value): java.lang.String
        )
      )(_.localPath)
      .s3DataType(s3DataType.unwrap)
      .optionallyWith(s3InputMode.map(value => value.unwrap))(_.s3InputMode)
      .optionallyWith(s3DataDistributionType.map(value => value.unwrap))(
        _.s3DataDistributionType
      )
      .optionallyWith(s3CompressionType.map(value => value.unwrap))(
        _.s3CompressionType
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ProcessingS3Input.ReadOnly =
    zio.aws.sagemaker.model.ProcessingS3Input.wrap(buildAwsValue())
}
object ProcessingS3Input {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProcessingS3Input
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProcessingS3Input =
      zio.aws.sagemaker.model.ProcessingS3Input(
        s3Uri,
        localPath.map(value => value),
        s3DataType,
        s3InputMode.map(value => value),
        s3DataDistributionType.map(value => value),
        s3CompressionType.map(value => value)
      )
    def s3Uri: S3Uri
    def localPath: Optional[ProcessingLocalPath]
    def s3DataType: zio.aws.sagemaker.model.ProcessingS3DataType
    def s3InputMode: Optional[zio.aws.sagemaker.model.ProcessingS3InputMode]
    def s3DataDistributionType
        : Optional[zio.aws.sagemaker.model.ProcessingS3DataDistributionType]
    def s3CompressionType
        : Optional[zio.aws.sagemaker.model.ProcessingS3CompressionType]
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getLocalPath: ZIO[Any, AwsError, ProcessingLocalPath] =
      AwsError.unwrapOptionField("localPath", localPath)
    def getS3DataType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ProcessingS3DataType] =
      ZIO.succeed(s3DataType)
    def getS3InputMode
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ProcessingS3InputMode] =
      AwsError.unwrapOptionField("s3InputMode", s3InputMode)
    def getS3DataDistributionType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProcessingS3DataDistributionType
    ] = AwsError.unwrapOptionField(
      "s3DataDistributionType",
      s3DataDistributionType
    )
    def getS3CompressionType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProcessingS3CompressionType
    ] = AwsError.unwrapOptionField("s3CompressionType", s3CompressionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingS3Input
  ) extends zio.aws.sagemaker.model.ProcessingS3Input.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.s3Uri())
    override val localPath: Optional[ProcessingLocalPath] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localPath())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ProcessingLocalPath(value)
        )
    override val s3DataType: zio.aws.sagemaker.model.ProcessingS3DataType =
      zio.aws.sagemaker.model.ProcessingS3DataType.wrap(impl.s3DataType())
    override val s3InputMode
        : Optional[zio.aws.sagemaker.model.ProcessingS3InputMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3InputMode())
        .map(value => zio.aws.sagemaker.model.ProcessingS3InputMode.wrap(value))
    override val s3DataDistributionType
        : Optional[zio.aws.sagemaker.model.ProcessingS3DataDistributionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3DataDistributionType())
        .map(value =>
          zio.aws.sagemaker.model.ProcessingS3DataDistributionType.wrap(value)
        )
    override val s3CompressionType
        : Optional[zio.aws.sagemaker.model.ProcessingS3CompressionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3CompressionType())
        .map(value =>
          zio.aws.sagemaker.model.ProcessingS3CompressionType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingS3Input
  ): zio.aws.sagemaker.model.ProcessingS3Input.ReadOnly = new Wrapper(impl)
}
