package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  MonitoringAlertName,
  MonitoringScheduleName
}
import scala.jdk.CollectionConverters._
final case class MonitoringAlertHistorySummary(
    monitoringScheduleName: MonitoringScheduleName,
    monitoringAlertName: MonitoringAlertName,
    creationTime: Timestamp,
    alertStatus: zio.aws.sagemaker.model.MonitoringAlertStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringAlertHistorySummary = {
    import MonitoringAlertHistorySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringAlertHistorySummary
      .builder()
      .monitoringScheduleName(
        MonitoringScheduleName.unwrap(monitoringScheduleName): java.lang.String
      )
      .monitoringAlertName(
        MonitoringAlertName.unwrap(monitoringAlertName): java.lang.String
      )
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .alertStatus(alertStatus.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.MonitoringAlertHistorySummary.ReadOnly =
    zio.aws.sagemaker.model.MonitoringAlertHistorySummary.wrap(buildAwsValue())
}
object MonitoringAlertHistorySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringAlertHistorySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringAlertHistorySummary =
      zio.aws.sagemaker.model.MonitoringAlertHistorySummary(
        monitoringScheduleName,
        monitoringAlertName,
        creationTime,
        alertStatus
      )
    def monitoringScheduleName: MonitoringScheduleName
    def monitoringAlertName: MonitoringAlertName
    def creationTime: Timestamp
    def alertStatus: zio.aws.sagemaker.model.MonitoringAlertStatus
    def getMonitoringScheduleName: ZIO[Any, Nothing, MonitoringScheduleName] =
      ZIO.succeed(monitoringScheduleName)
    def getMonitoringAlertName: ZIO[Any, Nothing, MonitoringAlertName] =
      ZIO.succeed(monitoringAlertName)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getAlertStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.MonitoringAlertStatus] =
      ZIO.succeed(alertStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringAlertHistorySummary
  ) extends zio.aws.sagemaker.model.MonitoringAlertHistorySummary.ReadOnly {
    override val monitoringScheduleName: MonitoringScheduleName =
      zio.aws.sagemaker.model.primitives
        .MonitoringScheduleName(impl.monitoringScheduleName())
    override val monitoringAlertName: MonitoringAlertName =
      zio.aws.sagemaker.model.primitives
        .MonitoringAlertName(impl.monitoringAlertName())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val alertStatus: zio.aws.sagemaker.model.MonitoringAlertStatus =
      zio.aws.sagemaker.model.MonitoringAlertStatus.wrap(impl.alertStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringAlertHistorySummary
  ): zio.aws.sagemaker.model.MonitoringAlertHistorySummary.ReadOnly =
    new Wrapper(impl)
}
