package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{ModelVariantName, ModelName}
import scala.jdk.CollectionConverters._
final case class ModelVariantConfigSummary(
    modelName: ModelName,
    variantName: ModelVariantName,
    infrastructureConfig: zio.aws.sagemaker.model.ModelInfrastructureConfig,
    status: zio.aws.sagemaker.model.ModelVariantStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelVariantConfigSummary = {
    import ModelVariantConfigSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelVariantConfigSummary
      .builder()
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .variantName(ModelVariantName.unwrap(variantName): java.lang.String)
      .infrastructureConfig(infrastructureConfig.buildAwsValue())
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelVariantConfigSummary.ReadOnly =
    zio.aws.sagemaker.model.ModelVariantConfigSummary.wrap(buildAwsValue())
}
object ModelVariantConfigSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelVariantConfigSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelVariantConfigSummary =
      zio.aws.sagemaker.model.ModelVariantConfigSummary(
        modelName,
        variantName,
        infrastructureConfig.asEditable,
        status
      )
    def modelName: ModelName
    def variantName: ModelVariantName
    def infrastructureConfig
        : zio.aws.sagemaker.model.ModelInfrastructureConfig.ReadOnly
    def status: zio.aws.sagemaker.model.ModelVariantStatus
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
    def getVariantName: ZIO[Any, Nothing, ModelVariantName] =
      ZIO.succeed(variantName)
    def getInfrastructureConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ModelInfrastructureConfig.ReadOnly
    ] = ZIO.succeed(infrastructureConfig)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ModelVariantStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelVariantConfigSummary
  ) extends zio.aws.sagemaker.model.ModelVariantConfigSummary.ReadOnly {
    override val modelName: ModelName =
      zio.aws.sagemaker.model.primitives.ModelName(impl.modelName())
    override val variantName: ModelVariantName =
      zio.aws.sagemaker.model.primitives.ModelVariantName(impl.variantName())
    override val infrastructureConfig
        : zio.aws.sagemaker.model.ModelInfrastructureConfig.ReadOnly =
      zio.aws.sagemaker.model.ModelInfrastructureConfig
        .wrap(impl.infrastructureConfig())
    override val status: zio.aws.sagemaker.model.ModelVariantStatus =
      zio.aws.sagemaker.model.ModelVariantStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelVariantConfigSummary
  ): zio.aws.sagemaker.model.ModelVariantConfigSummary.ReadOnly = new Wrapper(
    impl
  )
}
