package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  NotebookInstanceLifecycleConfigNameContains,
  NextToken,
  LastModifiedTime,
  MaxResults
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListNotebookInstanceLifecycleConfigsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    sortBy: Optional[
      zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortKey
    ] = Optional.Absent,
    sortOrder: Optional[
      zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder
    ] = Optional.Absent,
    nameContains: Optional[NotebookInstanceLifecycleConfigNameContains] =
      Optional.Absent,
    creationTimeBefore: Optional[CreationTime] = Optional.Absent,
    creationTimeAfter: Optional[CreationTime] = Optional.Absent,
    lastModifiedTimeBefore: Optional[LastModifiedTime] = Optional.Absent,
    lastModifiedTimeAfter: Optional[LastModifiedTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest = {
    import ListNotebookInstanceLifecycleConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nameContains.map(value =>
          NotebookInstanceLifecycleConfigNameContains.unwrap(
            value
          ): java.lang.String
        )
      )(_.nameContains)
      .optionallyWith(
        creationTimeBefore.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        creationTimeAfter.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        lastModifiedTimeBefore.map(value =>
          LastModifiedTime.unwrap(value): Instant
        )
      )(_.lastModifiedTimeBefore)
      .optionallyWith(
        lastModifiedTimeAfter.map(value =>
          LastModifiedTime.unwrap(value): Instant
        )
      )(_.lastModifiedTimeAfter)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest
      .wrap(buildAwsValue())
}
object ListNotebookInstanceLifecycleConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest =
      zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nameContains.map(value => value),
        creationTimeBefore.map(value => value),
        creationTimeAfter.map(value => value),
        lastModifiedTimeBefore.map(value => value),
        lastModifiedTimeAfter.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def sortBy: Optional[
      zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortKey
    ]
    def sortOrder: Optional[
      zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder
    ]
    def nameContains: Optional[NotebookInstanceLifecycleConfigNameContains]
    def creationTimeBefore: Optional[CreationTime]
    def creationTimeAfter: Optional[CreationTime]
    def lastModifiedTimeBefore: Optional[LastModifiedTime]
    def lastModifiedTimeAfter: Optional[LastModifiedTime]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortKey
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder
    ] = AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNameContains
        : ZIO[Any, AwsError, NotebookInstanceLifecycleConfigNameContains] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getCreationTimeBefore: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getCreationTimeAfter: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getLastModifiedTimeBefore: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField(
        "lastModifiedTimeBefore",
        lastModifiedTimeBefore
      )
    def getLastModifiedTimeAfter: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTimeAfter", lastModifiedTimeAfter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest
  ) extends zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val sortBy: Optional[
      zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortKey
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sortBy())
      .map(value =>
        zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortKey
          .wrap(value)
      )
    override val sortOrder: Optional[
      zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sortOrder())
      .map(value =>
        zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder
          .wrap(value)
      )
    override val nameContains
        : Optional[NotebookInstanceLifecycleConfigNameContains] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nameContains())
        .map(value =>
          zio.aws.sagemaker.model.primitives
            .NotebookInstanceLifecycleConfigNameContains(value)
        )
    override val creationTimeBefore: Optional[CreationTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTimeBefore())
        .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val creationTimeAfter: Optional[CreationTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTimeAfter())
        .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val lastModifiedTimeBefore: Optional[LastModifiedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTimeBefore())
        .map(value =>
          zio.aws.sagemaker.model.primitives.LastModifiedTime(value)
        )
    override val lastModifiedTimeAfter: Optional[LastModifiedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTimeAfter())
        .map(value =>
          zio.aws.sagemaker.model.primitives.LastModifiedTime(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest
  ): zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest.ReadOnly =
    new Wrapper(impl)
}
