package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListMonitoringAlertsResponse(
    monitoringAlertSummaries: Optional[
      Iterable[zio.aws.sagemaker.model.MonitoringAlertSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertsResponse = {
    import ListMonitoringAlertsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertsResponse
      .builder()
      .optionallyWith(
        monitoringAlertSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.monitoringAlertSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListMonitoringAlertsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListMonitoringAlertsResponse.wrap(buildAwsValue())
}
object ListMonitoringAlertsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListMonitoringAlertsResponse =
      zio.aws.sagemaker.model.ListMonitoringAlertsResponse(
        monitoringAlertSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def monitoringAlertSummaries: Optional[
      List[zio.aws.sagemaker.model.MonitoringAlertSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getMonitoringAlertSummaries: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.MonitoringAlertSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "monitoringAlertSummaries",
      monitoringAlertSummaries
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertsResponse
  ) extends zio.aws.sagemaker.model.ListMonitoringAlertsResponse.ReadOnly {
    override val monitoringAlertSummaries: Optional[
      List[zio.aws.sagemaker.model.MonitoringAlertSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoringAlertSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.MonitoringAlertSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertsResponse
  ): zio.aws.sagemaker.model.ListMonitoringAlertsResponse.ReadOnly =
    new Wrapper(impl)
}
