package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListHubContentsResponse(
    hubContentSummaries: Iterable[zio.aws.sagemaker.model.HubContentInfo],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListHubContentsResponse = {
    import ListHubContentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListHubContentsResponse
      .builder()
      .hubContentSummaries(hubContentSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListHubContentsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListHubContentsResponse.wrap(buildAwsValue())
}
object ListHubContentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListHubContentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListHubContentsResponse =
      zio.aws.sagemaker.model.ListHubContentsResponse(
        hubContentSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def hubContentSummaries
        : List[zio.aws.sagemaker.model.HubContentInfo.ReadOnly]
    def nextToken: Optional[NextToken]
    def getHubContentSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.HubContentInfo.ReadOnly
    ]] = ZIO.succeed(hubContentSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListHubContentsResponse
  ) extends zio.aws.sagemaker.model.ListHubContentsResponse.ReadOnly {
    override val hubContentSummaries
        : List[zio.aws.sagemaker.model.HubContentInfo.ReadOnly] = impl
      .hubContentSummaries()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.HubContentInfo.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListHubContentsResponse
  ): zio.aws.sagemaker.model.ListHubContentsResponse.ReadOnly = new Wrapper(
    impl
  )
}
