package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  SageMakerImageVersionAlias
}
import scala.jdk.CollectionConverters._
final case class ListAliasesResponse(
    sageMakerImageVersionAliases: Optional[
      Iterable[SageMakerImageVersionAlias]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListAliasesResponse = {
    import ListAliasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListAliasesResponse
      .builder()
      .optionallyWith(
        sageMakerImageVersionAliases.map(value =>
          value.map { item =>
            SageMakerImageVersionAlias.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sageMakerImageVersionAliases)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListAliasesResponse.ReadOnly =
    zio.aws.sagemaker.model.ListAliasesResponse.wrap(buildAwsValue())
}
object ListAliasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListAliasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListAliasesResponse =
      zio.aws.sagemaker.model.ListAliasesResponse(
        sageMakerImageVersionAliases.map(value => value),
        nextToken.map(value => value)
      )
    def sageMakerImageVersionAliases: Optional[List[SageMakerImageVersionAlias]]
    def nextToken: Optional[NextToken]
    def getSageMakerImageVersionAliases
        : ZIO[Any, AwsError, List[SageMakerImageVersionAlias]] =
      AwsError.unwrapOptionField(
        "sageMakerImageVersionAliases",
        sageMakerImageVersionAliases
      )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAliasesResponse
  ) extends zio.aws.sagemaker.model.ListAliasesResponse.ReadOnly {
    override val sageMakerImageVersionAliases
        : Optional[List[SageMakerImageVersionAlias]] = zio.aws.core.internal
      .optionalFromNullable(impl.sageMakerImageVersionAliases())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.SageMakerImageVersionAlias(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAliasesResponse
  ): zio.aws.sagemaker.model.ListAliasesResponse.ReadOnly = new Wrapper(impl)
}
