package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait InferenceExperimentType {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.InferenceExperimentType
}
object InferenceExperimentType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.InferenceExperimentType
  ): zio.aws.sagemaker.model.InferenceExperimentType = value match {
    case software.amazon.awssdk.services.sagemaker.model.InferenceExperimentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.InferenceExperimentType.SHADOW_MODE =>
      val r = ShadowMode
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.InferenceExperimentType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.InferenceExperimentType =
      software.amazon.awssdk.services.sagemaker.model.InferenceExperimentType.UNKNOWN_TO_SDK_VERSION
  }
  case object ShadowMode
      extends zio.aws.sagemaker.model.InferenceExperimentType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.InferenceExperimentType =
      software.amazon.awssdk.services.sagemaker.model.InferenceExperimentType.SHADOW_MODE
  }
}
