package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{SpaceName, DomainId}
import scala.jdk.CollectionConverters._
final case class DescribeSpaceRequest(
    domainId: DomainId,
    spaceName: SpaceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeSpaceRequest = {
    import DescribeSpaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeSpaceRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .spaceName(SpaceName.unwrap(spaceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeSpaceRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeSpaceRequest.wrap(buildAwsValue())
}
object DescribeSpaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeSpaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeSpaceRequest =
      zio.aws.sagemaker.model.DescribeSpaceRequest(domainId, spaceName)
    def domainId: DomainId
    def spaceName: SpaceName
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getSpaceName: ZIO[Any, Nothing, SpaceName] = ZIO.succeed(spaceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeSpaceRequest
  ) extends zio.aws.sagemaker.model.DescribeSpaceRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.sagemaker.model.primitives.DomainId(impl.domainId())
    override val spaceName: SpaceName =
      zio.aws.sagemaker.model.primitives.SpaceName(impl.spaceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeSpaceRequest
  ): zio.aws.sagemaker.model.DescribeSpaceRequest.ReadOnly = new Wrapper(impl)
}
