package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ProjectEntityName
import scala.jdk.CollectionConverters._
final case class DescribeProjectRequest(projectName: ProjectEntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeProjectRequest = {
    import DescribeProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeProjectRequest
      .builder()
      .projectName(ProjectEntityName.unwrap(projectName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeProjectRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeProjectRequest.wrap(buildAwsValue())
}
object DescribeProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeProjectRequest =
      zio.aws.sagemaker.model.DescribeProjectRequest(projectName)
    def projectName: ProjectEntityName
    def getProjectName: ZIO[Any, Nothing, ProjectEntityName] =
      ZIO.succeed(projectName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeProjectRequest
  ) extends zio.aws.sagemaker.model.DescribeProjectRequest.ReadOnly {
    override val projectName: ProjectEntityName =
      zio.aws.sagemaker.model.primitives.ProjectEntityName(impl.projectName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeProjectRequest
  ): zio.aws.sagemaker.model.DescribeProjectRequest.ReadOnly = new Wrapper(impl)
}
