package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  LastModifiedTime,
  NotebookInstanceLifecycleConfigName,
  NotebookInstanceLifecycleConfigArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeNotebookInstanceLifecycleConfigResponse(
    notebookInstanceLifecycleConfigArn: Optional[
      NotebookInstanceLifecycleConfigArn
    ] = Optional.Absent,
    notebookInstanceLifecycleConfigName: Optional[
      NotebookInstanceLifecycleConfigName
    ] = Optional.Absent,
    onCreate: Optional[
      Iterable[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook]
    ] = Optional.Absent,
    onStart: Optional[
      Iterable[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook]
    ] = Optional.Absent,
    lastModifiedTime: Optional[LastModifiedTime] = Optional.Absent,
    creationTime: Optional[CreationTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse = {
    import DescribeNotebookInstanceLifecycleConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse
      .builder()
      .optionallyWith(
        notebookInstanceLifecycleConfigArn.map(value =>
          NotebookInstanceLifecycleConfigArn.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceLifecycleConfigArn)
      .optionallyWith(
        notebookInstanceLifecycleConfigName.map(value =>
          NotebookInstanceLifecycleConfigName.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceLifecycleConfigName)
      .optionallyWith(
        onCreate.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.onCreate)
      .optionallyWith(
        onStart.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.onStart)
      .optionallyWith(
        lastModifiedTime.map(value => LastModifiedTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse
      .wrap(buildAwsValue())
}
object DescribeNotebookInstanceLifecycleConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse =
      zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse(
        notebookInstanceLifecycleConfigArn.map(value => value),
        notebookInstanceLifecycleConfigName.map(value => value),
        onCreate.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        onStart.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastModifiedTime.map(value => value),
        creationTime.map(value => value)
      )
    def notebookInstanceLifecycleConfigArn
        : Optional[NotebookInstanceLifecycleConfigArn]
    def notebookInstanceLifecycleConfigName
        : Optional[NotebookInstanceLifecycleConfigName]
    def onCreate: Optional[
      List[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly]
    ]
    def onStart: Optional[
      List[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly]
    ]
    def lastModifiedTime: Optional[LastModifiedTime]
    def creationTime: Optional[CreationTime]
    def getNotebookInstanceLifecycleConfigArn
        : ZIO[Any, AwsError, NotebookInstanceLifecycleConfigArn] =
      AwsError.unwrapOptionField(
        "notebookInstanceLifecycleConfigArn",
        notebookInstanceLifecycleConfigArn
      )
    def getNotebookInstanceLifecycleConfigName
        : ZIO[Any, AwsError, NotebookInstanceLifecycleConfigName] =
      AwsError.unwrapOptionField(
        "notebookInstanceLifecycleConfigName",
        notebookInstanceLifecycleConfigName
      )
    def getOnCreate: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly
    ]] = AwsError.unwrapOptionField("onCreate", onCreate)
    def getOnStart: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly
    ]] = AwsError.unwrapOptionField("onStart", onStart)
    def getLastModifiedTime: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse
  ) extends zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse.ReadOnly {
    override val notebookInstanceLifecycleConfigArn
        : Optional[NotebookInstanceLifecycleConfigArn] = zio.aws.core.internal
      .optionalFromNullable(impl.notebookInstanceLifecycleConfigArn())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .NotebookInstanceLifecycleConfigArn(value)
      )
    override val notebookInstanceLifecycleConfigName
        : Optional[NotebookInstanceLifecycleConfigName] = zio.aws.core.internal
      .optionalFromNullable(impl.notebookInstanceLifecycleConfigName())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .NotebookInstanceLifecycleConfigName(value)
      )
    override val onCreate: Optional[
      List[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.onCreate())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.wrap(item)
        }.toList
      )
    override val onStart: Optional[
      List[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.onStart())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.wrap(item)
        }.toList
      )
    override val lastModifiedTime: Optional[LastModifiedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value =>
          zio.aws.sagemaker.model.primitives.LastModifiedTime(value)
        )
    override val creationTime: Optional[CreationTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse
  ): zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse.ReadOnly =
    new Wrapper(impl)
}
