package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ExperimentEntityName
import scala.jdk.CollectionConverters._
final case class DescribeLineageGroupRequest(
    lineageGroupName: ExperimentEntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeLineageGroupRequest = {
    import DescribeLineageGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeLineageGroupRequest
      .builder()
      .lineageGroupName(
        ExperimentEntityName.unwrap(lineageGroupName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeLineageGroupRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeLineageGroupRequest.wrap(buildAwsValue())
}
object DescribeLineageGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeLineageGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeLineageGroupRequest =
      zio.aws.sagemaker.model.DescribeLineageGroupRequest(lineageGroupName)
    def lineageGroupName: ExperimentEntityName
    def getLineageGroupName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(lineageGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeLineageGroupRequest
  ) extends zio.aws.sagemaker.model.DescribeLineageGroupRequest.ReadOnly {
    override val lineageGroupName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives
        .ExperimentEntityName(impl.lineageGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeLineageGroupRequest
  ): zio.aws.sagemaker.model.DescribeLineageGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
