package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  Timestamp,
  InferenceExperimentName,
  InferenceExperimentDescription,
  KmsKeyId,
  InferenceExperimentStatusReason,
  InferenceExperimentArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeInferenceExperimentResponse(
    arn: InferenceExperimentArn,
    name: InferenceExperimentName,
    `type`: zio.aws.sagemaker.model.InferenceExperimentType,
    schedule: Optional[zio.aws.sagemaker.model.InferenceExperimentSchedule] =
      Optional.Absent,
    status: zio.aws.sagemaker.model.InferenceExperimentStatus,
    statusReason: Optional[InferenceExperimentStatusReason] = Optional.Absent,
    description: Optional[InferenceExperimentDescription] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    completionTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    endpointMetadata: zio.aws.sagemaker.model.EndpointMetadata,
    modelVariants: Iterable[zio.aws.sagemaker.model.ModelVariantConfigSummary],
    dataStorageConfig: Optional[
      zio.aws.sagemaker.model.InferenceExperimentDataStorageConfig
    ] = Optional.Absent,
    shadowModeConfig: Optional[zio.aws.sagemaker.model.ShadowModeConfig] =
      Optional.Absent,
    kmsKey: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeInferenceExperimentResponse = {
    import DescribeInferenceExperimentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeInferenceExperimentResponse
      .builder()
      .arn(InferenceExperimentArn.unwrap(arn): java.lang.String)
      .name(InferenceExperimentName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .status(status.unwrap)
      .optionallyWith(
        statusReason.map(value =>
          InferenceExperimentStatusReason.unwrap(value): java.lang.String
        )
      )(_.statusReason)
      .optionallyWith(
        description.map(value =>
          InferenceExperimentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        completionTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.completionTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .endpointMetadata(endpointMetadata.buildAwsValue())
      .modelVariants(modelVariants.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(dataStorageConfig.map(value => value.buildAwsValue()))(
        _.dataStorageConfig
      )
      .optionallyWith(shadowModeConfig.map(value => value.buildAwsValue()))(
        _.shadowModeConfig
      )
      .optionallyWith(
        kmsKey.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeInferenceExperimentResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeInferenceExperimentResponse
      .wrap(buildAwsValue())
}
object DescribeInferenceExperimentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeInferenceExperimentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DescribeInferenceExperimentResponse =
      zio.aws.sagemaker.model.DescribeInferenceExperimentResponse(
        arn,
        name,
        `type`,
        schedule.map(value => value.asEditable),
        status,
        statusReason.map(value => value),
        description.map(value => value),
        creationTime.map(value => value),
        completionTime.map(value => value),
        lastModifiedTime.map(value => value),
        roleArn.map(value => value),
        endpointMetadata.asEditable,
        modelVariants.map { item =>
          item.asEditable
        },
        dataStorageConfig.map(value => value.asEditable),
        shadowModeConfig.map(value => value.asEditable),
        kmsKey.map(value => value)
      )
    def arn: InferenceExperimentArn
    def name: InferenceExperimentName
    def `type`: zio.aws.sagemaker.model.InferenceExperimentType
    def schedule
        : Optional[zio.aws.sagemaker.model.InferenceExperimentSchedule.ReadOnly]
    def status: zio.aws.sagemaker.model.InferenceExperimentStatus
    def statusReason: Optional[InferenceExperimentStatusReason]
    def description: Optional[InferenceExperimentDescription]
    def creationTime: Optional[Timestamp]
    def completionTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def roleArn: Optional[RoleArn]
    def endpointMetadata: zio.aws.sagemaker.model.EndpointMetadata.ReadOnly
    def modelVariants
        : List[zio.aws.sagemaker.model.ModelVariantConfigSummary.ReadOnly]
    def dataStorageConfig: Optional[
      zio.aws.sagemaker.model.InferenceExperimentDataStorageConfig.ReadOnly
    ]
    def shadowModeConfig
        : Optional[zio.aws.sagemaker.model.ShadowModeConfig.ReadOnly]
    def kmsKey: Optional[KmsKeyId]
    def getArn: ZIO[Any, Nothing, InferenceExperimentArn] = ZIO.succeed(arn)
    def getName: ZIO[Any, Nothing, InferenceExperimentName] = ZIO.succeed(name)
    def getType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.InferenceExperimentType] =
      ZIO.succeed(`type`)
    def getSchedule: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.InferenceExperimentSchedule.ReadOnly
    ] = AwsError.unwrapOptionField("schedule", schedule)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.InferenceExperimentStatus] =
      ZIO.succeed(status)
    def getStatusReason: ZIO[Any, AwsError, InferenceExperimentStatusReason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getDescription: ZIO[Any, AwsError, InferenceExperimentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCompletionTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getEndpointMetadata
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.EndpointMetadata.ReadOnly] =
      ZIO.succeed(endpointMetadata)
    def getModelVariants: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.ModelVariantConfigSummary.ReadOnly
    ]] = ZIO.succeed(modelVariants)
    def getDataStorageConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.InferenceExperimentDataStorageConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dataStorageConfig", dataStorageConfig)
    def getShadowModeConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ShadowModeConfig.ReadOnly
    ] = AwsError.unwrapOptionField("shadowModeConfig", shadowModeConfig)
    def getKmsKey: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeInferenceExperimentResponse
  ) extends zio.aws.sagemaker.model.DescribeInferenceExperimentResponse.ReadOnly {
    override val arn: InferenceExperimentArn =
      zio.aws.sagemaker.model.primitives.InferenceExperimentArn(impl.arn())
    override val name: InferenceExperimentName =
      zio.aws.sagemaker.model.primitives.InferenceExperimentName(impl.name())
    override val `type`: zio.aws.sagemaker.model.InferenceExperimentType =
      zio.aws.sagemaker.model.InferenceExperimentType.wrap(impl.`type`())
    override val schedule: Optional[
      zio.aws.sagemaker.model.InferenceExperimentSchedule.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.schedule())
      .map(value =>
        zio.aws.sagemaker.model.InferenceExperimentSchedule.wrap(value)
      )
    override val status: zio.aws.sagemaker.model.InferenceExperimentStatus =
      zio.aws.sagemaker.model.InferenceExperimentStatus.wrap(impl.status())
    override val statusReason: Optional[InferenceExperimentStatusReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusReason())
        .map(value =>
          zio.aws.sagemaker.model.primitives
            .InferenceExperimentStatusReason(value)
        )
    override val description: Optional[InferenceExperimentDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.sagemaker.model.primitives
            .InferenceExperimentDescription(value)
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val completionTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.completionTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val endpointMetadata
        : zio.aws.sagemaker.model.EndpointMetadata.ReadOnly =
      zio.aws.sagemaker.model.EndpointMetadata.wrap(impl.endpointMetadata())
    override val modelVariants
        : List[zio.aws.sagemaker.model.ModelVariantConfigSummary.ReadOnly] =
      impl
        .modelVariants()
        .asScala
        .map { item =>
          zio.aws.sagemaker.model.ModelVariantConfigSummary.wrap(item)
        }
        .toList
    override val dataStorageConfig: Optional[
      zio.aws.sagemaker.model.InferenceExperimentDataStorageConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataStorageConfig())
      .map(value =>
        zio.aws.sagemaker.model.InferenceExperimentDataStorageConfig.wrap(value)
      )
    override val shadowModeConfig
        : Optional[zio.aws.sagemaker.model.ShadowModeConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shadowModeConfig())
        .map(value => zio.aws.sagemaker.model.ShadowModeConfig.wrap(value))
    override val kmsKey: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKey())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeInferenceExperimentResponse
  ): zio.aws.sagemaker.model.DescribeInferenceExperimentResponse.ReadOnly =
    new Wrapper(impl)
}
