package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.TrainingJobArn
import scala.jdk.CollectionConverters._
final case class CreateTrainingJobResponse(trainingJobArn: TrainingJobArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobResponse = {
    import CreateTrainingJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobResponse
      .builder()
      .trainingJobArn(TrainingJobArn.unwrap(trainingJobArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateTrainingJobResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateTrainingJobResponse.wrap(buildAwsValue())
}
object CreateTrainingJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateTrainingJobResponse =
      zio.aws.sagemaker.model.CreateTrainingJobResponse(trainingJobArn)
    def trainingJobArn: TrainingJobArn
    def getTrainingJobArn: ZIO[Any, Nothing, TrainingJobArn] =
      ZIO.succeed(trainingJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobResponse
  ) extends zio.aws.sagemaker.model.CreateTrainingJobResponse.ReadOnly {
    override val trainingJobArn: TrainingJobArn =
      zio.aws.sagemaker.model.primitives.TrainingJobArn(impl.trainingJobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobResponse
  ): zio.aws.sagemaker.model.CreateTrainingJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
