package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{ProjectId, ProjectArn}
import scala.jdk.CollectionConverters._
final case class CreateProjectResponse(
    projectArn: ProjectArn,
    projectId: ProjectId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateProjectResponse = {
    import CreateProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateProjectResponse
      .builder()
      .projectArn(ProjectArn.unwrap(projectArn): java.lang.String)
      .projectId(ProjectId.unwrap(projectId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateProjectResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateProjectResponse.wrap(buildAwsValue())
}
object CreateProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateProjectResponse =
      zio.aws.sagemaker.model.CreateProjectResponse(projectArn, projectId)
    def projectArn: ProjectArn
    def projectId: ProjectId
    def getProjectArn: ZIO[Any, Nothing, ProjectArn] = ZIO.succeed(projectArn)
    def getProjectId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(projectId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateProjectResponse
  ) extends zio.aws.sagemaker.model.CreateProjectResponse.ReadOnly {
    override val projectArn: ProjectArn =
      zio.aws.sagemaker.model.primitives.ProjectArn(impl.projectArn())
    override val projectId: ProjectId =
      zio.aws.sagemaker.model.primitives.ProjectId(impl.projectId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateProjectResponse
  ): zio.aws.sagemaker.model.CreateProjectResponse.ReadOnly = new Wrapper(impl)
}
