package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.InferenceExperimentArn
import scala.jdk.CollectionConverters._
final case class CreateInferenceExperimentResponse(
    inferenceExperimentArn: InferenceExperimentArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateInferenceExperimentResponse = {
    import CreateInferenceExperimentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateInferenceExperimentResponse
      .builder()
      .inferenceExperimentArn(
        InferenceExperimentArn.unwrap(inferenceExperimentArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateInferenceExperimentResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateInferenceExperimentResponse
      .wrap(buildAwsValue())
}
object CreateInferenceExperimentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateInferenceExperimentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateInferenceExperimentResponse =
      zio.aws.sagemaker.model
        .CreateInferenceExperimentResponse(inferenceExperimentArn)
    def inferenceExperimentArn: InferenceExperimentArn
    def getInferenceExperimentArn: ZIO[Any, Nothing, InferenceExperimentArn] =
      ZIO.succeed(inferenceExperimentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateInferenceExperimentResponse
  ) extends zio.aws.sagemaker.model.CreateInferenceExperimentResponse.ReadOnly {
    override val inferenceExperimentArn: InferenceExperimentArn =
      zio.aws.sagemaker.model.primitives
        .InferenceExperimentArn(impl.inferenceExperimentArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateInferenceExperimentResponse
  ): zio.aws.sagemaker.model.CreateInferenceExperimentResponse.ReadOnly =
    new Wrapper(impl)
}
