package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  Url,
  ClarifyShapBaseline,
  ClarifyMimeType
}
import scala.jdk.CollectionConverters._
final case class ClarifyShapBaselineConfig(
    mimeType: Optional[ClarifyMimeType] = Optional.Absent,
    shapBaseline: Optional[ClarifyShapBaseline] = Optional.Absent,
    shapBaselineUri: Optional[Url] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ClarifyShapBaselineConfig = {
    import ClarifyShapBaselineConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ClarifyShapBaselineConfig
      .builder()
      .optionallyWith(
        mimeType.map(value => ClarifyMimeType.unwrap(value): java.lang.String)
      )(_.mimeType)
      .optionallyWith(
        shapBaseline.map(value =>
          ClarifyShapBaseline.unwrap(value): java.lang.String
        )
      )(_.shapBaseline)
      .optionallyWith(
        shapBaselineUri.map(value => Url.unwrap(value): java.lang.String)
      )(_.shapBaselineUri)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ClarifyShapBaselineConfig.ReadOnly =
    zio.aws.sagemaker.model.ClarifyShapBaselineConfig.wrap(buildAwsValue())
}
object ClarifyShapBaselineConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ClarifyShapBaselineConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ClarifyShapBaselineConfig =
      zio.aws.sagemaker.model.ClarifyShapBaselineConfig(
        mimeType.map(value => value),
        shapBaseline.map(value => value),
        shapBaselineUri.map(value => value)
      )
    def mimeType: Optional[ClarifyMimeType]
    def shapBaseline: Optional[ClarifyShapBaseline]
    def shapBaselineUri: Optional[Url]
    def getMimeType: ZIO[Any, AwsError, ClarifyMimeType] =
      AwsError.unwrapOptionField("mimeType", mimeType)
    def getShapBaseline: ZIO[Any, AwsError, ClarifyShapBaseline] =
      AwsError.unwrapOptionField("shapBaseline", shapBaseline)
    def getShapBaselineUri: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("shapBaselineUri", shapBaselineUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ClarifyShapBaselineConfig
  ) extends zio.aws.sagemaker.model.ClarifyShapBaselineConfig.ReadOnly {
    override val mimeType: Optional[ClarifyMimeType] = zio.aws.core.internal
      .optionalFromNullable(impl.mimeType())
      .map(value => zio.aws.sagemaker.model.primitives.ClarifyMimeType(value))
    override val shapBaseline: Optional[ClarifyShapBaseline] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shapBaseline())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ClarifyShapBaseline(value)
        )
    override val shapBaselineUri: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.shapBaselineUri())
      .map(value => zio.aws.sagemaker.model.primitives.Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ClarifyShapBaselineConfig
  ): zio.aws.sagemaker.model.ClarifyShapBaselineConfig.ReadOnly = new Wrapper(
    impl
  )
}
