package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{String128, String64}
import scala.jdk.CollectionConverters._
final case class CategoricalParameter(
    name: String64,
    value: Iterable[String128]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CategoricalParameter = {
    import CategoricalParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CategoricalParameter
      .builder()
      .name(String64.unwrap(name): java.lang.String)
      .value(value.map { item =>
        String128.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CategoricalParameter.ReadOnly =
    zio.aws.sagemaker.model.CategoricalParameter.wrap(buildAwsValue())
}
object CategoricalParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CategoricalParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CategoricalParameter =
      zio.aws.sagemaker.model.CategoricalParameter(name, value)
    def name: String64
    def value: List[String128]
    def getName: ZIO[Any, Nothing, String64] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, List[String128]] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CategoricalParameter
  ) extends zio.aws.sagemaker.model.CategoricalParameter.ReadOnly {
    override val name: String64 =
      zio.aws.sagemaker.model.primitives.String64(impl.name())
    override val value: List[String128] = impl
      .value()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.primitives.String128(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CategoricalParameter
  ): zio.aws.sagemaker.model.CategoricalParameter.ReadOnly = new Wrapper(impl)
}
