package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{KmsKeyId, S3Uri}
import scala.jdk.CollectionConverters._
final case class BatchDataCaptureConfig(
    destinationS3Uri: S3Uri,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    generateInferenceId: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.BatchDataCaptureConfig = {
    import BatchDataCaptureConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.BatchDataCaptureConfig
      .builder()
      .destinationS3Uri(S3Uri.unwrap(destinationS3Uri): java.lang.String)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        generateInferenceId.map(value => value: java.lang.Boolean)
      )(_.generateInferenceId)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.BatchDataCaptureConfig.ReadOnly =
    zio.aws.sagemaker.model.BatchDataCaptureConfig.wrap(buildAwsValue())
}
object BatchDataCaptureConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.BatchDataCaptureConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.BatchDataCaptureConfig =
      zio.aws.sagemaker.model.BatchDataCaptureConfig(
        destinationS3Uri,
        kmsKeyId.map(value => value),
        generateInferenceId.map(value => value)
      )
    def destinationS3Uri: S3Uri
    def kmsKeyId: Optional[KmsKeyId]
    def generateInferenceId: Optional[Boolean]
    def getDestinationS3Uri: ZIO[Any, Nothing, S3Uri] =
      ZIO.succeed(destinationS3Uri)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getGenerateInferenceId: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("generateInferenceId", generateInferenceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.BatchDataCaptureConfig
  ) extends zio.aws.sagemaker.model.BatchDataCaptureConfig.ReadOnly {
    override val destinationS3Uri: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.destinationS3Uri())
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val generateInferenceId: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.generateInferenceId())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.BatchDataCaptureConfig
  ): zio.aws.sagemaker.model.BatchDataCaptureConfig.ReadOnly = new Wrapper(impl)
}
