package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters._
final case class AlgorithmValidationProfile(
    profileName: EntityName,
    trainingJobDefinition: zio.aws.sagemaker.model.TrainingJobDefinition,
    transformJobDefinition: Optional[
      zio.aws.sagemaker.model.TransformJobDefinition
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AlgorithmValidationProfile = {
    import AlgorithmValidationProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AlgorithmValidationProfile
      .builder()
      .profileName(EntityName.unwrap(profileName): java.lang.String)
      .trainingJobDefinition(trainingJobDefinition.buildAwsValue())
      .optionallyWith(
        transformJobDefinition.map(value => value.buildAwsValue())
      )(_.transformJobDefinition)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AlgorithmValidationProfile.ReadOnly =
    zio.aws.sagemaker.model.AlgorithmValidationProfile.wrap(buildAwsValue())
}
object AlgorithmValidationProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AlgorithmValidationProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AlgorithmValidationProfile =
      zio.aws.sagemaker.model.AlgorithmValidationProfile(
        profileName,
        trainingJobDefinition.asEditable,
        transformJobDefinition.map(value => value.asEditable)
      )
    def profileName: EntityName
    def trainingJobDefinition
        : zio.aws.sagemaker.model.TrainingJobDefinition.ReadOnly
    def transformJobDefinition
        : Optional[zio.aws.sagemaker.model.TransformJobDefinition.ReadOnly]
    def getProfileName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(profileName)
    def getTrainingJobDefinition: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.TrainingJobDefinition.ReadOnly
    ] = ZIO.succeed(trainingJobDefinition)
    def getTransformJobDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TransformJobDefinition.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transformJobDefinition",
      transformJobDefinition
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AlgorithmValidationProfile
  ) extends zio.aws.sagemaker.model.AlgorithmValidationProfile.ReadOnly {
    override val profileName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.profileName())
    override val trainingJobDefinition
        : zio.aws.sagemaker.model.TrainingJobDefinition.ReadOnly =
      zio.aws.sagemaker.model.TrainingJobDefinition
        .wrap(impl.trainingJobDefinition())
    override val transformJobDefinition
        : Optional[zio.aws.sagemaker.model.TransformJobDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transformJobDefinition())
        .map(value =>
          zio.aws.sagemaker.model.TransformJobDefinition.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AlgorithmValidationProfile
  ): zio.aws.sagemaker.model.AlgorithmValidationProfile.ReadOnly = new Wrapper(
    impl
  )
}
