package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.HubArn
import scala.jdk.CollectionConverters._
final case class UpdateHubResponse(hubArn: HubArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateHubResponse = {
    import UpdateHubResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateHubResponse
      .builder()
      .hubArn(HubArn.unwrap(hubArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateHubResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdateHubResponse.wrap(buildAwsValue())
}
object UpdateHubResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateHubResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateHubResponse =
      zio.aws.sagemaker.model.UpdateHubResponse(hubArn)
    def hubArn: HubArn
    def getHubArn: ZIO[Any, Nothing, HubArn] = ZIO.succeed(hubArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateHubResponse
  ) extends zio.aws.sagemaker.model.UpdateHubResponse.ReadOnly {
    override val hubArn: HubArn =
      zio.aws.sagemaker.model.primitives.HubArn(impl.hubArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateHubResponse
  ): zio.aws.sagemaker.model.UpdateHubResponse.ReadOnly = new Wrapper(impl)
}
