package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.RecommendationJobName
import scala.jdk.CollectionConverters._
final case class InferenceRecommendationsJobStep(
    stepType: zio.aws.sagemaker.model.RecommendationStepType,
    jobName: RecommendationJobName,
    status: zio.aws.sagemaker.model.RecommendationJobStatus,
    inferenceBenchmark: Optional[
      zio.aws.sagemaker.model.RecommendationJobInferenceBenchmark
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.InferenceRecommendationsJobStep = {
    import InferenceRecommendationsJobStep.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.InferenceRecommendationsJobStep
      .builder()
      .stepType(stepType.unwrap)
      .jobName(RecommendationJobName.unwrap(jobName): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(inferenceBenchmark.map(value => value.buildAwsValue()))(
        _.inferenceBenchmark
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.InferenceRecommendationsJobStep.ReadOnly =
    zio.aws.sagemaker.model.InferenceRecommendationsJobStep
      .wrap(buildAwsValue())
}
object InferenceRecommendationsJobStep {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.InferenceRecommendationsJobStep
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.InferenceRecommendationsJobStep =
      zio.aws.sagemaker.model.InferenceRecommendationsJobStep(
        stepType,
        jobName,
        status,
        inferenceBenchmark.map(value => value.asEditable)
      )
    def stepType: zio.aws.sagemaker.model.RecommendationStepType
    def jobName: RecommendationJobName
    def status: zio.aws.sagemaker.model.RecommendationJobStatus
    def inferenceBenchmark: Optional[
      zio.aws.sagemaker.model.RecommendationJobInferenceBenchmark.ReadOnly
    ]
    def getStepType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.RecommendationStepType] =
      ZIO.succeed(stepType)
    def getJobName: ZIO[Any, Nothing, RecommendationJobName] =
      ZIO.succeed(jobName)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.RecommendationJobStatus] =
      ZIO.succeed(status)
    def getInferenceBenchmark: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RecommendationJobInferenceBenchmark.ReadOnly
    ] = AwsError.unwrapOptionField("inferenceBenchmark", inferenceBenchmark)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.InferenceRecommendationsJobStep
  ) extends zio.aws.sagemaker.model.InferenceRecommendationsJobStep.ReadOnly {
    override val stepType: zio.aws.sagemaker.model.RecommendationStepType =
      zio.aws.sagemaker.model.RecommendationStepType.wrap(impl.stepType())
    override val jobName: RecommendationJobName =
      zio.aws.sagemaker.model.primitives.RecommendationJobName(impl.jobName())
    override val status: zio.aws.sagemaker.model.RecommendationJobStatus =
      zio.aws.sagemaker.model.RecommendationJobStatus.wrap(impl.status())
    override val inferenceBenchmark: Optional[
      zio.aws.sagemaker.model.RecommendationJobInferenceBenchmark.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inferenceBenchmark())
      .map(value =>
        zio.aws.sagemaker.model.RecommendationJobInferenceBenchmark.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.InferenceRecommendationsJobStep
  ): zio.aws.sagemaker.model.InferenceRecommendationsJobStep.ReadOnly =
    new Wrapper(impl)
}
