package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  HubSearchKeyword,
  Timestamp,
  FailureReason,
  HubContentVersion,
  HubContentName,
  HubContentArn,
  HubContentDescription,
  HubContentDisplayName,
  DocumentSchemaVersion,
  HubName,
  HubArn,
  HubContentMarkdown,
  HubContentDocument
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeHubContentResponse(
    hubContentName: HubContentName,
    hubContentArn: HubContentArn,
    hubContentVersion: HubContentVersion,
    hubContentType: zio.aws.sagemaker.model.HubContentType,
    documentSchemaVersion: DocumentSchemaVersion,
    hubName: HubName,
    hubArn: HubArn,
    hubContentDisplayName: Optional[HubContentDisplayName] = Optional.Absent,
    hubContentDescription: Optional[HubContentDescription] = Optional.Absent,
    hubContentMarkdown: Optional[HubContentMarkdown] = Optional.Absent,
    hubContentDocument: HubContentDocument,
    hubContentSearchKeywords: Optional[Iterable[HubSearchKeyword]] =
      Optional.Absent,
    hubContentDependencies: Optional[
      Iterable[zio.aws.sagemaker.model.HubContentDependency]
    ] = Optional.Absent,
    hubContentStatus: zio.aws.sagemaker.model.HubContentStatus,
    failureReason: Optional[FailureReason] = Optional.Absent,
    creationTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeHubContentResponse = {
    import DescribeHubContentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeHubContentResponse
      .builder()
      .hubContentName(HubContentName.unwrap(hubContentName): java.lang.String)
      .hubContentArn(HubContentArn.unwrap(hubContentArn): java.lang.String)
      .hubContentVersion(
        HubContentVersion.unwrap(hubContentVersion): java.lang.String
      )
      .hubContentType(hubContentType.unwrap)
      .documentSchemaVersion(
        DocumentSchemaVersion.unwrap(documentSchemaVersion): java.lang.String
      )
      .hubName(HubName.unwrap(hubName): java.lang.String)
      .hubArn(HubArn.unwrap(hubArn): java.lang.String)
      .optionallyWith(
        hubContentDisplayName.map(value =>
          HubContentDisplayName.unwrap(value): java.lang.String
        )
      )(_.hubContentDisplayName)
      .optionallyWith(
        hubContentDescription.map(value =>
          HubContentDescription.unwrap(value): java.lang.String
        )
      )(_.hubContentDescription)
      .optionallyWith(
        hubContentMarkdown.map(value =>
          HubContentMarkdown.unwrap(value): java.lang.String
        )
      )(_.hubContentMarkdown)
      .hubContentDocument(
        HubContentDocument.unwrap(hubContentDocument): java.lang.String
      )
      .optionallyWith(
        hubContentSearchKeywords.map(value =>
          value.map { item =>
            HubSearchKeyword.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.hubContentSearchKeywords)
      .optionallyWith(
        hubContentDependencies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hubContentDependencies)
      .hubContentStatus(hubContentStatus.unwrap)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeHubContentResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeHubContentResponse.wrap(buildAwsValue())
}
object DescribeHubContentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeHubContentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeHubContentResponse =
      zio.aws.sagemaker.model.DescribeHubContentResponse(
        hubContentName,
        hubContentArn,
        hubContentVersion,
        hubContentType,
        documentSchemaVersion,
        hubName,
        hubArn,
        hubContentDisplayName.map(value => value),
        hubContentDescription.map(value => value),
        hubContentMarkdown.map(value => value),
        hubContentDocument,
        hubContentSearchKeywords.map(value => value),
        hubContentDependencies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hubContentStatus,
        failureReason.map(value => value),
        creationTime
      )
    def hubContentName: HubContentName
    def hubContentArn: HubContentArn
    def hubContentVersion: HubContentVersion
    def hubContentType: zio.aws.sagemaker.model.HubContentType
    def documentSchemaVersion: DocumentSchemaVersion
    def hubName: HubName
    def hubArn: HubArn
    def hubContentDisplayName: Optional[HubContentDisplayName]
    def hubContentDescription: Optional[HubContentDescription]
    def hubContentMarkdown: Optional[HubContentMarkdown]
    def hubContentDocument: HubContentDocument
    def hubContentSearchKeywords: Optional[List[HubSearchKeyword]]
    def hubContentDependencies
        : Optional[List[zio.aws.sagemaker.model.HubContentDependency.ReadOnly]]
    def hubContentStatus: zio.aws.sagemaker.model.HubContentStatus
    def failureReason: Optional[FailureReason]
    def creationTime: Timestamp
    def getHubContentName: ZIO[Any, Nothing, HubContentName] =
      ZIO.succeed(hubContentName)
    def getHubContentArn: ZIO[Any, Nothing, HubContentArn] =
      ZIO.succeed(hubContentArn)
    def getHubContentVersion: ZIO[Any, Nothing, HubContentVersion] =
      ZIO.succeed(hubContentVersion)
    def getHubContentType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.HubContentType] =
      ZIO.succeed(hubContentType)
    def getDocumentSchemaVersion: ZIO[Any, Nothing, DocumentSchemaVersion] =
      ZIO.succeed(documentSchemaVersion)
    def getHubName: ZIO[Any, Nothing, HubName] = ZIO.succeed(hubName)
    def getHubArn: ZIO[Any, Nothing, HubArn] = ZIO.succeed(hubArn)
    def getHubContentDisplayName: ZIO[Any, AwsError, HubContentDisplayName] =
      AwsError.unwrapOptionField("hubContentDisplayName", hubContentDisplayName)
    def getHubContentDescription: ZIO[Any, AwsError, HubContentDescription] =
      AwsError.unwrapOptionField("hubContentDescription", hubContentDescription)
    def getHubContentMarkdown: ZIO[Any, AwsError, HubContentMarkdown] =
      AwsError.unwrapOptionField("hubContentMarkdown", hubContentMarkdown)
    def getHubContentDocument: ZIO[Any, Nothing, HubContentDocument] =
      ZIO.succeed(hubContentDocument)
    def getHubContentSearchKeywords
        : ZIO[Any, AwsError, List[HubSearchKeyword]] = AwsError
      .unwrapOptionField("hubContentSearchKeywords", hubContentSearchKeywords)
    def getHubContentDependencies: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.HubContentDependency.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "hubContentDependencies",
      hubContentDependencies
    )
    def getHubContentStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.HubContentStatus] =
      ZIO.succeed(hubContentStatus)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeHubContentResponse
  ) extends zio.aws.sagemaker.model.DescribeHubContentResponse.ReadOnly {
    override val hubContentName: HubContentName =
      zio.aws.sagemaker.model.primitives.HubContentName(impl.hubContentName())
    override val hubContentArn: HubContentArn =
      zio.aws.sagemaker.model.primitives.HubContentArn(impl.hubContentArn())
    override val hubContentVersion: HubContentVersion =
      zio.aws.sagemaker.model.primitives
        .HubContentVersion(impl.hubContentVersion())
    override val hubContentType: zio.aws.sagemaker.model.HubContentType =
      zio.aws.sagemaker.model.HubContentType.wrap(impl.hubContentType())
    override val documentSchemaVersion: DocumentSchemaVersion =
      zio.aws.sagemaker.model.primitives
        .DocumentSchemaVersion(impl.documentSchemaVersion())
    override val hubName: HubName =
      zio.aws.sagemaker.model.primitives.HubName(impl.hubName())
    override val hubArn: HubArn =
      zio.aws.sagemaker.model.primitives.HubArn(impl.hubArn())
    override val hubContentDisplayName: Optional[HubContentDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubContentDisplayName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.HubContentDisplayName(value)
        )
    override val hubContentDescription: Optional[HubContentDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubContentDescription())
        .map(value =>
          zio.aws.sagemaker.model.primitives.HubContentDescription(value)
        )
    override val hubContentMarkdown: Optional[HubContentMarkdown] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubContentMarkdown())
        .map(value =>
          zio.aws.sagemaker.model.primitives.HubContentMarkdown(value)
        )
    override val hubContentDocument: HubContentDocument =
      zio.aws.sagemaker.model.primitives
        .HubContentDocument(impl.hubContentDocument())
    override val hubContentSearchKeywords: Optional[List[HubSearchKeyword]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubContentSearchKeywords())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.HubSearchKeyword(item)
          }.toList
        )
    override val hubContentDependencies: Optional[
      List[zio.aws.sagemaker.model.HubContentDependency.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.hubContentDependencies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.HubContentDependency.wrap(item)
        }.toList
      )
    override val hubContentStatus: zio.aws.sagemaker.model.HubContentStatus =
      zio.aws.sagemaker.model.HubContentStatus.wrap(impl.hubContentStatus())
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeHubContentResponse
  ): zio.aws.sagemaker.model.DescribeHubContentResponse.ReadOnly = new Wrapper(
    impl
  )
}
