package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait AutoMLMode {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.AutoMLMode
}
object AutoMLMode {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AutoMLMode
  ): zio.aws.sagemaker.model.AutoMLMode = value match {
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMode.AUTO =>
      val r = AUTO
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMode.ENSEMBLING =>
      val r = ENSEMBLING
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMode.HYPERPARAMETER_TUNING =>
      val r = HYPERPARAMETER_TUNING
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.AutoMLMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMode =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMode.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTO extends zio.aws.sagemaker.model.AutoMLMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMode =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMode.AUTO
  }
  case object ENSEMBLING extends zio.aws.sagemaker.model.AutoMLMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMode =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMode.ENSEMBLING
  }
  case object HYPERPARAMETER_TUNING extends zio.aws.sagemaker.model.AutoMLMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMode =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMode.HYPERPARAMETER_TUNING
  }
}
