package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait WarmPoolResourceStatus {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.WarmPoolResourceStatus
}
object WarmPoolResourceStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.WarmPoolResourceStatus
  ): zio.aws.sagemaker.model.WarmPoolResourceStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.WarmPoolResourceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.WarmPoolResourceStatus.AVAILABLE =>
      val r = Available
      r
    case software.amazon.awssdk.services.sagemaker.model.WarmPoolResourceStatus.TERMINATED =>
      val r = Terminated
      r
    case software.amazon.awssdk.services.sagemaker.model.WarmPoolResourceStatus.REUSED =>
      val r = Reused
      r
    case software.amazon.awssdk.services.sagemaker.model.WarmPoolResourceStatus.IN_USE =>
      val r = InUse
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.WarmPoolResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.WarmPoolResourceStatus =
      software.amazon.awssdk.services.sagemaker.model.WarmPoolResourceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Available extends zio.aws.sagemaker.model.WarmPoolResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.WarmPoolResourceStatus =
      software.amazon.awssdk.services.sagemaker.model.WarmPoolResourceStatus.AVAILABLE
  }
  case object Terminated
      extends zio.aws.sagemaker.model.WarmPoolResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.WarmPoolResourceStatus =
      software.amazon.awssdk.services.sagemaker.model.WarmPoolResourceStatus.TERMINATED
  }
  case object Reused extends zio.aws.sagemaker.model.WarmPoolResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.WarmPoolResourceStatus =
      software.amazon.awssdk.services.sagemaker.model.WarmPoolResourceStatus.REUSED
  }
  case object InUse extends zio.aws.sagemaker.model.WarmPoolResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.WarmPoolResourceStatus =
      software.amazon.awssdk.services.sagemaker.model.WarmPoolResourceStatus.IN_USE
  }
}
