package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{UtilizationMetric, Integer}
import scala.jdk.CollectionConverters._
final case class RecommendationMetrics(
    costPerHour: Float,
    costPerInference: Float,
    maxInvocations: Integer,
    modelLatency: Integer,
    cpuUtilization: Optional[UtilizationMetric] = Optional.Absent,
    memoryUtilization: Optional[UtilizationMetric] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RecommendationMetrics = {
    import RecommendationMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RecommendationMetrics
      .builder()
      .costPerHour(costPerHour: java.lang.Float)
      .costPerInference(costPerInference: java.lang.Float)
      .maxInvocations(maxInvocations: java.lang.Integer)
      .modelLatency(modelLatency: java.lang.Integer)
      .optionallyWith(
        cpuUtilization.map(value =>
          UtilizationMetric.unwrap(value): java.lang.Float
        )
      )(_.cpuUtilization)
      .optionallyWith(
        memoryUtilization.map(value =>
          UtilizationMetric.unwrap(value): java.lang.Float
        )
      )(_.memoryUtilization)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.RecommendationMetrics.ReadOnly =
    zio.aws.sagemaker.model.RecommendationMetrics.wrap(buildAwsValue())
}
object RecommendationMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RecommendationMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RecommendationMetrics =
      zio.aws.sagemaker.model.RecommendationMetrics(
        costPerHour,
        costPerInference,
        maxInvocations,
        modelLatency,
        cpuUtilization.map(value => value),
        memoryUtilization.map(value => value)
      )
    def costPerHour: Float
    def costPerInference: Float
    def maxInvocations: Integer
    def modelLatency: Integer
    def cpuUtilization: Optional[UtilizationMetric]
    def memoryUtilization: Optional[UtilizationMetric]
    def getCostPerHour: ZIO[Any, Nothing, Float] = ZIO.succeed(costPerHour)
    def getCostPerInference: ZIO[Any, Nothing, Float] =
      ZIO.succeed(costPerInference)
    def getMaxInvocations: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(maxInvocations)
    def getModelLatency: ZIO[Any, Nothing, Integer] = ZIO.succeed(modelLatency)
    def getCpuUtilization: ZIO[Any, AwsError, UtilizationMetric] =
      AwsError.unwrapOptionField("cpuUtilization", cpuUtilization)
    def getMemoryUtilization: ZIO[Any, AwsError, UtilizationMetric] =
      AwsError.unwrapOptionField("memoryUtilization", memoryUtilization)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationMetrics
  ) extends zio.aws.sagemaker.model.RecommendationMetrics.ReadOnly {
    override val costPerHour: Float = impl.costPerHour(): Float
    override val costPerInference: Float = impl.costPerInference(): Float
    override val maxInvocations: Integer = impl.maxInvocations(): Integer
    override val modelLatency: Integer = impl.modelLatency(): Integer
    override val cpuUtilization: Optional[UtilizationMetric] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cpuUtilization())
        .map(value =>
          zio.aws.sagemaker.model.primitives.UtilizationMetric(value)
        )
    override val memoryUtilization: Optional[UtilizationMetric] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memoryUtilization())
        .map(value =>
          zio.aws.sagemaker.model.primitives.UtilizationMetric(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationMetrics
  ): zio.aws.sagemaker.model.RecommendationMetrics.ReadOnly = new Wrapper(impl)
}
