package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModelDashboardModel(
    model: Optional[zio.aws.sagemaker.model.Model] = Optional.Absent,
    endpoints: Optional[
      Iterable[zio.aws.sagemaker.model.ModelDashboardEndpoint]
    ] = Optional.Absent,
    lastBatchTransformJob: Optional[zio.aws.sagemaker.model.TransformJob] =
      Optional.Absent,
    monitoringSchedules: Optional[
      Iterable[zio.aws.sagemaker.model.ModelDashboardMonitoringSchedule]
    ] = Optional.Absent,
    modelCard: Optional[zio.aws.sagemaker.model.ModelDashboardModelCard] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelDashboardModel = {
    import ModelDashboardModel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelDashboardModel
      .builder()
      .optionallyWith(model.map(value => value.buildAwsValue()))(_.model)
      .optionallyWith(
        endpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpoints)
      .optionallyWith(
        lastBatchTransformJob.map(value => value.buildAwsValue())
      )(_.lastBatchTransformJob)
      .optionallyWith(
        monitoringSchedules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.monitoringSchedules)
      .optionallyWith(modelCard.map(value => value.buildAwsValue()))(
        _.modelCard
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelDashboardModel.ReadOnly =
    zio.aws.sagemaker.model.ModelDashboardModel.wrap(buildAwsValue())
}
object ModelDashboardModel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelDashboardModel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelDashboardModel =
      zio.aws.sagemaker.model.ModelDashboardModel(
        model.map(value => value.asEditable),
        endpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastBatchTransformJob.map(value => value.asEditable),
        monitoringSchedules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        modelCard.map(value => value.asEditable)
      )
    def model: Optional[zio.aws.sagemaker.model.Model.ReadOnly]
    def endpoints: Optional[
      List[zio.aws.sagemaker.model.ModelDashboardEndpoint.ReadOnly]
    ]
    def lastBatchTransformJob
        : Optional[zio.aws.sagemaker.model.TransformJob.ReadOnly]
    def monitoringSchedules: Optional[
      List[zio.aws.sagemaker.model.ModelDashboardMonitoringSchedule.ReadOnly]
    ]
    def modelCard
        : Optional[zio.aws.sagemaker.model.ModelDashboardModelCard.ReadOnly]
    def getModel: ZIO[Any, AwsError, zio.aws.sagemaker.model.Model.ReadOnly] =
      AwsError.unwrapOptionField("model", model)
    def getEndpoints: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ModelDashboardEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("endpoints", endpoints)
    def getLastBatchTransformJob
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TransformJob.ReadOnly] =
      AwsError.unwrapOptionField("lastBatchTransformJob", lastBatchTransformJob)
    def getMonitoringSchedules: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ModelDashboardMonitoringSchedule.ReadOnly
    ]] = AwsError.unwrapOptionField("monitoringSchedules", monitoringSchedules)
    def getModelCard: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelDashboardModelCard.ReadOnly
    ] = AwsError.unwrapOptionField("modelCard", modelCard)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelDashboardModel
  ) extends zio.aws.sagemaker.model.ModelDashboardModel.ReadOnly {
    override val model: Optional[zio.aws.sagemaker.model.Model.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.model())
        .map(value => zio.aws.sagemaker.model.Model.wrap(value))
    override val endpoints: Optional[
      List[zio.aws.sagemaker.model.ModelDashboardEndpoint.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ModelDashboardEndpoint.wrap(item)
        }.toList
      )
    override val lastBatchTransformJob
        : Optional[zio.aws.sagemaker.model.TransformJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastBatchTransformJob())
        .map(value => zio.aws.sagemaker.model.TransformJob.wrap(value))
    override val monitoringSchedules: Optional[
      List[zio.aws.sagemaker.model.ModelDashboardMonitoringSchedule.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoringSchedules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ModelDashboardMonitoringSchedule.wrap(item)
        }.toList
      )
    override val modelCard
        : Optional[zio.aws.sagemaker.model.ModelDashboardModelCard.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelCard())
        .map(value =>
          zio.aws.sagemaker.model.ModelDashboardModelCard.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelDashboardModel
  ): zio.aws.sagemaker.model.ModelDashboardModel.ReadOnly = new Wrapper(impl)
}
