package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListTrialComponentsResponse(
    trialComponentSummaries: Optional[
      Iterable[zio.aws.sagemaker.model.TrialComponentSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsResponse = {
    import ListTrialComponentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsResponse
      .builder()
      .optionallyWith(
        trialComponentSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.trialComponentSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListTrialComponentsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListTrialComponentsResponse.wrap(buildAwsValue())
}
object ListTrialComponentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListTrialComponentsResponse =
      zio.aws.sagemaker.model.ListTrialComponentsResponse(
        trialComponentSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def trialComponentSummaries
        : Optional[List[zio.aws.sagemaker.model.TrialComponentSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getTrialComponentSummaries: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.TrialComponentSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "trialComponentSummaries",
      trialComponentSummaries
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsResponse
  ) extends zio.aws.sagemaker.model.ListTrialComponentsResponse.ReadOnly {
    override val trialComponentSummaries: Optional[
      List[zio.aws.sagemaker.model.TrialComponentSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.trialComponentSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.TrialComponentSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsResponse
  ): zio.aws.sagemaker.model.ListTrialComponentsResponse.ReadOnly = new Wrapper(
    impl
  )
}
