package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  EndpointName,
  Timestamp,
  FailureReason,
  EndpointArn,
  EndpointConfigName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Endpoint(
    endpointName: EndpointName,
    endpointArn: EndpointArn,
    endpointConfigName: EndpointConfigName,
    productionVariants: Optional[
      Iterable[zio.aws.sagemaker.model.ProductionVariantSummary]
    ] = Optional.Absent,
    dataCaptureConfig: Optional[
      zio.aws.sagemaker.model.DataCaptureConfigSummary
    ] = Optional.Absent,
    endpointStatus: zio.aws.sagemaker.model.EndpointStatus,
    failureReason: Optional[FailureReason] = Optional.Absent,
    creationTime: Timestamp,
    lastModifiedTime: Timestamp,
    monitoringSchedules: Optional[
      Iterable[zio.aws.sagemaker.model.MonitoringSchedule]
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent,
    shadowProductionVariants: Optional[
      Iterable[zio.aws.sagemaker.model.ProductionVariantSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.Endpoint = {
    import Endpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Endpoint
      .builder()
      .endpointName(EndpointName.unwrap(endpointName): java.lang.String)
      .endpointArn(EndpointArn.unwrap(endpointArn): java.lang.String)
      .endpointConfigName(
        EndpointConfigName.unwrap(endpointConfigName): java.lang.String
      )
      .optionallyWith(
        productionVariants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productionVariants)
      .optionallyWith(dataCaptureConfig.map(value => value.buildAwsValue()))(
        _.dataCaptureConfig
      )
      .endpointStatus(endpointStatus.unwrap)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .optionallyWith(
        monitoringSchedules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.monitoringSchedules)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        shadowProductionVariants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.shadowProductionVariants)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Endpoint.ReadOnly =
    zio.aws.sagemaker.model.Endpoint.wrap(buildAwsValue())
}
object Endpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.Endpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Endpoint =
      zio.aws.sagemaker.model.Endpoint(
        endpointName,
        endpointArn,
        endpointConfigName,
        productionVariants.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataCaptureConfig.map(value => value.asEditable),
        endpointStatus,
        failureReason.map(value => value),
        creationTime,
        lastModifiedTime,
        monitoringSchedules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        shadowProductionVariants.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def endpointName: EndpointName
    def endpointArn: EndpointArn
    def endpointConfigName: EndpointConfigName
    def productionVariants: Optional[
      List[zio.aws.sagemaker.model.ProductionVariantSummary.ReadOnly]
    ]
    def dataCaptureConfig
        : Optional[zio.aws.sagemaker.model.DataCaptureConfigSummary.ReadOnly]
    def endpointStatus: zio.aws.sagemaker.model.EndpointStatus
    def failureReason: Optional[FailureReason]
    def creationTime: Timestamp
    def lastModifiedTime: Timestamp
    def monitoringSchedules
        : Optional[List[zio.aws.sagemaker.model.MonitoringSchedule.ReadOnly]]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def shadowProductionVariants: Optional[
      List[zio.aws.sagemaker.model.ProductionVariantSummary.ReadOnly]
    ]
    def getEndpointName: ZIO[Any, Nothing, EndpointName] =
      ZIO.succeed(endpointName)
    def getEndpointArn: ZIO[Any, Nothing, EndpointArn] =
      ZIO.succeed(endpointArn)
    def getEndpointConfigName: ZIO[Any, Nothing, EndpointConfigName] =
      ZIO.succeed(endpointConfigName)
    def getProductionVariants: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ProductionVariantSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("productionVariants", productionVariants)
    def getDataCaptureConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DataCaptureConfigSummary.ReadOnly
    ] = AwsError.unwrapOptionField("dataCaptureConfig", dataCaptureConfig)
    def getEndpointStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.EndpointStatus] =
      ZIO.succeed(endpointStatus)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getMonitoringSchedules: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.MonitoringSchedule.ReadOnly
    ]] = AwsError.unwrapOptionField("monitoringSchedules", monitoringSchedules)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getShadowProductionVariants: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ProductionVariantSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "shadowProductionVariants",
      shadowProductionVariants
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Endpoint
  ) extends zio.aws.sagemaker.model.Endpoint.ReadOnly {
    override val endpointName: EndpointName =
      zio.aws.sagemaker.model.primitives.EndpointName(impl.endpointName())
    override val endpointArn: EndpointArn =
      zio.aws.sagemaker.model.primitives.EndpointArn(impl.endpointArn())
    override val endpointConfigName: EndpointConfigName =
      zio.aws.sagemaker.model.primitives
        .EndpointConfigName(impl.endpointConfigName())
    override val productionVariants: Optional[
      List[zio.aws.sagemaker.model.ProductionVariantSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.productionVariants())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ProductionVariantSummary.wrap(item)
        }.toList
      )
    override val dataCaptureConfig
        : Optional[zio.aws.sagemaker.model.DataCaptureConfigSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataCaptureConfig())
        .map(value =>
          zio.aws.sagemaker.model.DataCaptureConfigSummary.wrap(value)
        )
    override val endpointStatus: zio.aws.sagemaker.model.EndpointStatus =
      zio.aws.sagemaker.model.EndpointStatus.wrap(impl.endpointStatus())
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val lastModifiedTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.lastModifiedTime())
    override val monitoringSchedules
        : Optional[List[zio.aws.sagemaker.model.MonitoringSchedule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringSchedules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.MonitoringSchedule.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val shadowProductionVariants: Optional[
      List[zio.aws.sagemaker.model.ProductionVariantSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.shadowProductionVariants())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ProductionVariantSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Endpoint
  ): zio.aws.sagemaker.model.Endpoint.ReadOnly = new Wrapper(impl)
}
