package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeviceStats(
    connectedDeviceCount: Long,
    registeredDeviceCount: Long
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeviceStats = {
    import DeviceStats.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeviceStats
      .builder()
      .connectedDeviceCount(connectedDeviceCount: java.lang.Long)
      .registeredDeviceCount(registeredDeviceCount: java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeviceStats.ReadOnly =
    zio.aws.sagemaker.model.DeviceStats.wrap(buildAwsValue())
}
object DeviceStats {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeviceStats
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeviceStats =
      zio.aws.sagemaker.model
        .DeviceStats(connectedDeviceCount, registeredDeviceCount)
    def connectedDeviceCount: Long
    def registeredDeviceCount: Long
    def getConnectedDeviceCount: ZIO[Any, Nothing, Long] =
      ZIO.succeed(connectedDeviceCount)
    def getRegisteredDeviceCount: ZIO[Any, Nothing, Long] =
      ZIO.succeed(registeredDeviceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeviceStats
  ) extends zio.aws.sagemaker.model.DeviceStats.ReadOnly {
    override val connectedDeviceCount: Long = impl.connectedDeviceCount(): Long
    override val registeredDeviceCount: Long =
      impl.registeredDeviceCount(): Long
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeviceStats
  ): zio.aws.sagemaker.model.DeviceStats.ReadOnly = new Wrapper(impl)
}
