package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  FailureReason,
  LastModifiedTime,
  SpaceName,
  DomainId,
  SpaceArn,
  EfsUid
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeSpaceResponse(
    domainId: Optional[DomainId] = Optional.Absent,
    spaceArn: Optional[SpaceArn] = Optional.Absent,
    spaceName: Optional[SpaceName] = Optional.Absent,
    homeEfsFileSystemUid: Optional[EfsUid] = Optional.Absent,
    status: Optional[zio.aws.sagemaker.model.SpaceStatus] = Optional.Absent,
    lastModifiedTime: Optional[LastModifiedTime] = Optional.Absent,
    creationTime: Optional[CreationTime] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    spaceSettings: Optional[zio.aws.sagemaker.model.SpaceSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeSpaceResponse = {
    import DescribeSpaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeSpaceResponse
      .builder()
      .optionallyWith(
        domainId.map(value => DomainId.unwrap(value): java.lang.String)
      )(_.domainId)
      .optionallyWith(
        spaceArn.map(value => SpaceArn.unwrap(value): java.lang.String)
      )(_.spaceArn)
      .optionallyWith(
        spaceName.map(value => SpaceName.unwrap(value): java.lang.String)
      )(_.spaceName)
      .optionallyWith(
        homeEfsFileSystemUid.map(value =>
          EfsUid.unwrap(value): java.lang.String
        )
      )(_.homeEfsFileSystemUid)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastModifiedTime.map(value => LastModifiedTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(spaceSettings.map(value => value.buildAwsValue()))(
        _.spaceSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeSpaceResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeSpaceResponse.wrap(buildAwsValue())
}
object DescribeSpaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeSpaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeSpaceResponse =
      zio.aws.sagemaker.model.DescribeSpaceResponse(
        domainId.map(value => value),
        spaceArn.map(value => value),
        spaceName.map(value => value),
        homeEfsFileSystemUid.map(value => value),
        status.map(value => value),
        lastModifiedTime.map(value => value),
        creationTime.map(value => value),
        failureReason.map(value => value),
        spaceSettings.map(value => value.asEditable)
      )
    def domainId: Optional[DomainId]
    def spaceArn: Optional[SpaceArn]
    def spaceName: Optional[SpaceName]
    def homeEfsFileSystemUid: Optional[EfsUid]
    def status: Optional[zio.aws.sagemaker.model.SpaceStatus]
    def lastModifiedTime: Optional[LastModifiedTime]
    def creationTime: Optional[CreationTime]
    def failureReason: Optional[FailureReason]
    def spaceSettings: Optional[zio.aws.sagemaker.model.SpaceSettings.ReadOnly]
    def getDomainId: ZIO[Any, AwsError, DomainId] =
      AwsError.unwrapOptionField("domainId", domainId)
    def getSpaceArn: ZIO[Any, AwsError, SpaceArn] =
      AwsError.unwrapOptionField("spaceArn", spaceArn)
    def getSpaceName: ZIO[Any, AwsError, SpaceName] =
      AwsError.unwrapOptionField("spaceName", spaceName)
    def getHomeEfsFileSystemUid: ZIO[Any, AwsError, EfsUid] =
      AwsError.unwrapOptionField("homeEfsFileSystemUid", homeEfsFileSystemUid)
    def getStatus: ZIO[Any, AwsError, zio.aws.sagemaker.model.SpaceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getLastModifiedTime: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getSpaceSettings
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.SpaceSettings.ReadOnly] =
      AwsError.unwrapOptionField("spaceSettings", spaceSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeSpaceResponse
  ) extends zio.aws.sagemaker.model.DescribeSpaceResponse.ReadOnly {
    override val domainId: Optional[DomainId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainId())
      .map(value => zio.aws.sagemaker.model.primitives.DomainId(value))
    override val spaceArn: Optional[SpaceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.spaceArn())
      .map(value => zio.aws.sagemaker.model.primitives.SpaceArn(value))
    override val spaceName: Optional[SpaceName] = zio.aws.core.internal
      .optionalFromNullable(impl.spaceName())
      .map(value => zio.aws.sagemaker.model.primitives.SpaceName(value))
    override val homeEfsFileSystemUid: Optional[EfsUid] = zio.aws.core.internal
      .optionalFromNullable(impl.homeEfsFileSystemUid())
      .map(value => zio.aws.sagemaker.model.primitives.EfsUid(value))
    override val status: Optional[zio.aws.sagemaker.model.SpaceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sagemaker.model.SpaceStatus.wrap(value))
    override val lastModifiedTime: Optional[LastModifiedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value =>
          zio.aws.sagemaker.model.primitives.LastModifiedTime(value)
        )
    override val creationTime: Optional[CreationTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val spaceSettings
        : Optional[zio.aws.sagemaker.model.SpaceSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spaceSettings())
        .map(value => zio.aws.sagemaker.model.SpaceSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeSpaceResponse
  ): zio.aws.sagemaker.model.DescribeSpaceResponse.ReadOnly = new Wrapper(impl)
}
