package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  FailureReason,
  ModelCardExportJobArn,
  Integer,
  EntityName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeModelCardExportJobResponse(
    modelCardExportJobName: EntityName,
    modelCardExportJobArn: ModelCardExportJobArn,
    status: zio.aws.sagemaker.model.ModelCardExportJobStatus,
    modelCardName: EntityName,
    modelCardVersion: Integer,
    outputConfig: zio.aws.sagemaker.model.ModelCardExportOutputConfig,
    createdAt: Timestamp,
    lastModifiedAt: Timestamp,
    failureReason: Optional[FailureReason] = Optional.Absent,
    exportArtifacts: Optional[
      zio.aws.sagemaker.model.ModelCardExportArtifacts
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeModelCardExportJobResponse = {
    import DescribeModelCardExportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeModelCardExportJobResponse
      .builder()
      .modelCardExportJobName(
        EntityName.unwrap(modelCardExportJobName): java.lang.String
      )
      .modelCardExportJobArn(
        ModelCardExportJobArn.unwrap(modelCardExportJobArn): java.lang.String
      )
      .status(status.unwrap)
      .modelCardName(EntityName.unwrap(modelCardName): java.lang.String)
      .modelCardVersion(modelCardVersion: java.lang.Integer)
      .outputConfig(outputConfig.buildAwsValue())
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .lastModifiedAt(Timestamp.unwrap(lastModifiedAt): Instant)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(exportArtifacts.map(value => value.buildAwsValue()))(
        _.exportArtifacts
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeModelCardExportJobResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeModelCardExportJobResponse
      .wrap(buildAwsValue())
}
object DescribeModelCardExportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeModelCardExportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeModelCardExportJobResponse =
      zio.aws.sagemaker.model.DescribeModelCardExportJobResponse(
        modelCardExportJobName,
        modelCardExportJobArn,
        status,
        modelCardName,
        modelCardVersion,
        outputConfig.asEditable,
        createdAt,
        lastModifiedAt,
        failureReason.map(value => value),
        exportArtifacts.map(value => value.asEditable)
      )
    def modelCardExportJobName: EntityName
    def modelCardExportJobArn: ModelCardExportJobArn
    def status: zio.aws.sagemaker.model.ModelCardExportJobStatus
    def modelCardName: EntityName
    def modelCardVersion: Integer
    def outputConfig
        : zio.aws.sagemaker.model.ModelCardExportOutputConfig.ReadOnly
    def createdAt: Timestamp
    def lastModifiedAt: Timestamp
    def failureReason: Optional[FailureReason]
    def exportArtifacts
        : Optional[zio.aws.sagemaker.model.ModelCardExportArtifacts.ReadOnly]
    def getModelCardExportJobName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(modelCardExportJobName)
    def getModelCardExportJobArn: ZIO[Any, Nothing, ModelCardExportJobArn] =
      ZIO.succeed(modelCardExportJobArn)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ModelCardExportJobStatus] =
      ZIO.succeed(status)
    def getModelCardName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(modelCardName)
    def getModelCardVersion: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(modelCardVersion)
    def getOutputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ModelCardExportOutputConfig.ReadOnly
    ] = ZIO.succeed(outputConfig)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getLastModifiedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedAt)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getExportArtifacts: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelCardExportArtifacts.ReadOnly
    ] = AwsError.unwrapOptionField("exportArtifacts", exportArtifacts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelCardExportJobResponse
  ) extends zio.aws.sagemaker.model.DescribeModelCardExportJobResponse.ReadOnly {
    override val modelCardExportJobName: EntityName =
      zio.aws.sagemaker.model.primitives
        .EntityName(impl.modelCardExportJobName())
    override val modelCardExportJobArn: ModelCardExportJobArn =
      zio.aws.sagemaker.model.primitives
        .ModelCardExportJobArn(impl.modelCardExportJobArn())
    override val status: zio.aws.sagemaker.model.ModelCardExportJobStatus =
      zio.aws.sagemaker.model.ModelCardExportJobStatus.wrap(impl.status())
    override val modelCardName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.modelCardName())
    override val modelCardVersion: Integer = impl.modelCardVersion(): Integer
    override val outputConfig
        : zio.aws.sagemaker.model.ModelCardExportOutputConfig.ReadOnly =
      zio.aws.sagemaker.model.ModelCardExportOutputConfig
        .wrap(impl.outputConfig())
    override val createdAt: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.createdAt())
    override val lastModifiedAt: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.lastModifiedAt())
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val exportArtifacts
        : Optional[zio.aws.sagemaker.model.ModelCardExportArtifacts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportArtifacts())
        .map(value =>
          zio.aws.sagemaker.model.ModelCardExportArtifacts.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelCardExportJobResponse
  ): zio.aws.sagemaker.model.DescribeModelCardExportJobResponse.ReadOnly =
    new Wrapper(impl)
}
