package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.HubName
import scala.jdk.CollectionConverters._
final case class DescribeHubRequest(hubName: HubName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeHubRequest = {
    import DescribeHubRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeHubRequest
      .builder()
      .hubName(HubName.unwrap(hubName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeHubRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeHubRequest.wrap(buildAwsValue())
}
object DescribeHubRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeHubRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeHubRequest =
      zio.aws.sagemaker.model.DescribeHubRequest(hubName)
    def hubName: HubName
    def getHubName: ZIO[Any, Nothing, HubName] = ZIO.succeed(hubName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeHubRequest
  ) extends zio.aws.sagemaker.model.DescribeHubRequest.ReadOnly {
    override val hubName: HubName =
      zio.aws.sagemaker.model.primitives.HubName(impl.hubName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeHubRequest
  ): zio.aws.sagemaker.model.DescribeHubRequest.ReadOnly = new Wrapper(impl)
}
