package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{CandidateStepName, CandidateStepArn}
import scala.jdk.CollectionConverters._
final case class AutoMLCandidateStep(
    candidateStepType: zio.aws.sagemaker.model.CandidateStepType,
    candidateStepArn: CandidateStepArn,
    candidateStepName: CandidateStepName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoMLCandidateStep = {
    import AutoMLCandidateStep.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoMLCandidateStep
      .builder()
      .candidateStepType(candidateStepType.unwrap)
      .candidateStepArn(
        CandidateStepArn.unwrap(candidateStepArn): java.lang.String
      )
      .candidateStepName(
        CandidateStepName.unwrap(candidateStepName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AutoMLCandidateStep.ReadOnly =
    zio.aws.sagemaker.model.AutoMLCandidateStep.wrap(buildAwsValue())
}
object AutoMLCandidateStep {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoMLCandidateStep
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoMLCandidateStep =
      zio.aws.sagemaker.model.AutoMLCandidateStep(
        candidateStepType,
        candidateStepArn,
        candidateStepName
      )
    def candidateStepType: zio.aws.sagemaker.model.CandidateStepType
    def candidateStepArn: CandidateStepArn
    def candidateStepName: CandidateStepName
    def getCandidateStepType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.CandidateStepType] =
      ZIO.succeed(candidateStepType)
    def getCandidateStepArn: ZIO[Any, Nothing, CandidateStepArn] =
      ZIO.succeed(candidateStepArn)
    def getCandidateStepName: ZIO[Any, Nothing, CandidateStepName] =
      ZIO.succeed(candidateStepName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLCandidateStep
  ) extends zio.aws.sagemaker.model.AutoMLCandidateStep.ReadOnly {
    override val candidateStepType: zio.aws.sagemaker.model.CandidateStepType =
      zio.aws.sagemaker.model.CandidateStepType.wrap(impl.candidateStepType())
    override val candidateStepArn: CandidateStepArn =
      zio.aws.sagemaker.model.primitives
        .CandidateStepArn(impl.candidateStepArn())
    override val candidateStepName: CandidateStepName =
      zio.aws.sagemaker.model.primitives
        .CandidateStepName(impl.candidateStepName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLCandidateStep
  ): zio.aws.sagemaker.model.AutoMLCandidateStep.ReadOnly = new Wrapper(impl)
}
