package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ModelVariantStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ModelVariantStatus
}
object ModelVariantStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ModelVariantStatus
  ): zio.aws.sagemaker.model.ModelVariantStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.ModelVariantStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelVariantStatus.CREATING =>
      val r = Creating
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelVariantStatus.UPDATING =>
      val r = Updating
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelVariantStatus.IN_SERVICE =>
      val r = InService
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelVariantStatus.DELETING =>
      val r = Deleting
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelVariantStatus.DELETED =>
      val r = Deleted
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ModelVariantStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelVariantStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelVariantStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Creating extends zio.aws.sagemaker.model.ModelVariantStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelVariantStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelVariantStatus.CREATING
  }
  case object Updating extends zio.aws.sagemaker.model.ModelVariantStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelVariantStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelVariantStatus.UPDATING
  }
  case object InService extends zio.aws.sagemaker.model.ModelVariantStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelVariantStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelVariantStatus.IN_SERVICE
  }
  case object Deleting extends zio.aws.sagemaker.model.ModelVariantStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelVariantStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelVariantStatus.DELETING
  }
  case object Deleted extends zio.aws.sagemaker.model.ModelVariantStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelVariantStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelVariantStatus.DELETED
  }
}
