package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EndpointConfigName
import scala.jdk.CollectionConverters._
final case class DeleteEndpointConfigRequest(
    endpointConfigName: EndpointConfigName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteEndpointConfigRequest = {
    import DeleteEndpointConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteEndpointConfigRequest
      .builder()
      .endpointConfigName(
        EndpointConfigName.unwrap(endpointConfigName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteEndpointConfigRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteEndpointConfigRequest.wrap(buildAwsValue())
}
object DeleteEndpointConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteEndpointConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteEndpointConfigRequest =
      zio.aws.sagemaker.model.DeleteEndpointConfigRequest(endpointConfigName)
    def endpointConfigName: EndpointConfigName
    def getEndpointConfigName: ZIO[Any, Nothing, EndpointConfigName] =
      ZIO.succeed(endpointConfigName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteEndpointConfigRequest
  ) extends zio.aws.sagemaker.model.DeleteEndpointConfigRequest.ReadOnly {
    override val endpointConfigName: EndpointConfigName =
      zio.aws.sagemaker.model.primitives
        .EndpointConfigName(impl.endpointConfigName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteEndpointConfigRequest
  ): zio.aws.sagemaker.model.DeleteEndpointConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
