package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  TransformEnvironmentValue,
  MaxConcurrentTransforms,
  TransformEnvironmentKey,
  MaxPayloadInMB,
  ModelName,
  TransformJobName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateTransformJobRequest(
    transformJobName: TransformJobName,
    modelName: ModelName,
    maxConcurrentTransforms: Optional[MaxConcurrentTransforms] =
      Optional.Absent,
    modelClientConfig: Optional[zio.aws.sagemaker.model.ModelClientConfig] =
      Optional.Absent,
    maxPayloadInMB: Optional[MaxPayloadInMB] = Optional.Absent,
    batchStrategy: Optional[zio.aws.sagemaker.model.BatchStrategy] =
      Optional.Absent,
    environment: Optional[
      Map[TransformEnvironmentKey, TransformEnvironmentValue]
    ] = Optional.Absent,
    transformInput: zio.aws.sagemaker.model.TransformInput,
    transformOutput: zio.aws.sagemaker.model.TransformOutput,
    dataCaptureConfig: Optional[
      zio.aws.sagemaker.model.BatchDataCaptureConfig
    ] = Optional.Absent,
    transformResources: zio.aws.sagemaker.model.TransformResources,
    dataProcessing: Optional[zio.aws.sagemaker.model.DataProcessing] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent,
    experimentConfig: Optional[zio.aws.sagemaker.model.ExperimentConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateTransformJobRequest = {
    import CreateTransformJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateTransformJobRequest
      .builder()
      .transformJobName(
        TransformJobName.unwrap(transformJobName): java.lang.String
      )
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .optionallyWith(
        maxConcurrentTransforms.map(value =>
          MaxConcurrentTransforms.unwrap(value): Integer
        )
      )(_.maxConcurrentTransforms)
      .optionallyWith(modelClientConfig.map(value => value.buildAwsValue()))(
        _.modelClientConfig
      )
      .optionallyWith(
        maxPayloadInMB.map(value => MaxPayloadInMB.unwrap(value): Integer)
      )(_.maxPayloadInMB)
      .optionallyWith(batchStrategy.map(value => value.unwrap))(_.batchStrategy)
      .optionallyWith(
        environment.map(value =>
          value
            .map({ case (key, value) =>
              (TransformEnvironmentKey.unwrap(
                key
              ): java.lang.String) -> (TransformEnvironmentValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.environment)
      .transformInput(transformInput.buildAwsValue())
      .transformOutput(transformOutput.buildAwsValue())
      .optionallyWith(dataCaptureConfig.map(value => value.buildAwsValue()))(
        _.dataCaptureConfig
      )
      .transformResources(transformResources.buildAwsValue())
      .optionallyWith(dataProcessing.map(value => value.buildAwsValue()))(
        _.dataProcessing
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(experimentConfig.map(value => value.buildAwsValue()))(
        _.experimentConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateTransformJobRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateTransformJobRequest.wrap(buildAwsValue())
}
object CreateTransformJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateTransformJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateTransformJobRequest =
      zio.aws.sagemaker.model.CreateTransformJobRequest(
        transformJobName,
        modelName,
        maxConcurrentTransforms.map(value => value),
        modelClientConfig.map(value => value.asEditable),
        maxPayloadInMB.map(value => value),
        batchStrategy.map(value => value),
        environment.map(value => value),
        transformInput.asEditable,
        transformOutput.asEditable,
        dataCaptureConfig.map(value => value.asEditable),
        transformResources.asEditable,
        dataProcessing.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        experimentConfig.map(value => value.asEditable)
      )
    def transformJobName: TransformJobName
    def modelName: ModelName
    def maxConcurrentTransforms: Optional[MaxConcurrentTransforms]
    def modelClientConfig
        : Optional[zio.aws.sagemaker.model.ModelClientConfig.ReadOnly]
    def maxPayloadInMB: Optional[MaxPayloadInMB]
    def batchStrategy: Optional[zio.aws.sagemaker.model.BatchStrategy]
    def environment
        : Optional[Map[TransformEnvironmentKey, TransformEnvironmentValue]]
    def transformInput: zio.aws.sagemaker.model.TransformInput.ReadOnly
    def transformOutput: zio.aws.sagemaker.model.TransformOutput.ReadOnly
    def dataCaptureConfig
        : Optional[zio.aws.sagemaker.model.BatchDataCaptureConfig.ReadOnly]
    def transformResources: zio.aws.sagemaker.model.TransformResources.ReadOnly
    def dataProcessing
        : Optional[zio.aws.sagemaker.model.DataProcessing.ReadOnly]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def experimentConfig
        : Optional[zio.aws.sagemaker.model.ExperimentConfig.ReadOnly]
    def getTransformJobName: ZIO[Any, Nothing, TransformJobName] =
      ZIO.succeed(transformJobName)
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
    def getMaxConcurrentTransforms
        : ZIO[Any, AwsError, MaxConcurrentTransforms] = AwsError
      .unwrapOptionField("maxConcurrentTransforms", maxConcurrentTransforms)
    def getModelClientConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelClientConfig.ReadOnly
    ] = AwsError.unwrapOptionField("modelClientConfig", modelClientConfig)
    def getMaxPayloadInMB: ZIO[Any, AwsError, MaxPayloadInMB] =
      AwsError.unwrapOptionField("maxPayloadInMB", maxPayloadInMB)
    def getBatchStrategy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.BatchStrategy] =
      AwsError.unwrapOptionField("batchStrategy", batchStrategy)
    def getEnvironment: ZIO[Any, AwsError, Map[
      TransformEnvironmentKey,
      TransformEnvironmentValue
    ]] = AwsError.unwrapOptionField("environment", environment)
    def getTransformInput
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.TransformInput.ReadOnly] =
      ZIO.succeed(transformInput)
    def getTransformOutput
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.TransformOutput.ReadOnly] =
      ZIO.succeed(transformOutput)
    def getDataCaptureConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.BatchDataCaptureConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dataCaptureConfig", dataCaptureConfig)
    def getTransformResources: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.TransformResources.ReadOnly
    ] = ZIO.succeed(transformResources)
    def getDataProcessing
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.DataProcessing.ReadOnly] =
      AwsError.unwrapOptionField("dataProcessing", dataProcessing)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getExperimentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ExperimentConfig.ReadOnly
    ] = AwsError.unwrapOptionField("experimentConfig", experimentConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateTransformJobRequest
  ) extends zio.aws.sagemaker.model.CreateTransformJobRequest.ReadOnly {
    override val transformJobName: TransformJobName =
      zio.aws.sagemaker.model.primitives
        .TransformJobName(impl.transformJobName())
    override val modelName: ModelName =
      zio.aws.sagemaker.model.primitives.ModelName(impl.modelName())
    override val maxConcurrentTransforms: Optional[MaxConcurrentTransforms] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConcurrentTransforms())
        .map(value =>
          zio.aws.sagemaker.model.primitives.MaxConcurrentTransforms(value)
        )
    override val modelClientConfig
        : Optional[zio.aws.sagemaker.model.ModelClientConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelClientConfig())
        .map(value => zio.aws.sagemaker.model.ModelClientConfig.wrap(value))
    override val maxPayloadInMB: Optional[MaxPayloadInMB] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxPayloadInMB())
        .map(value => zio.aws.sagemaker.model.primitives.MaxPayloadInMB(value))
    override val batchStrategy
        : Optional[zio.aws.sagemaker.model.BatchStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.batchStrategy())
        .map(value => zio.aws.sagemaker.model.BatchStrategy.wrap(value))
    override val environment
        : Optional[Map[TransformEnvironmentKey, TransformEnvironmentValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.TransformEnvironmentKey(
                key
              ) -> zio.aws.sagemaker.model.primitives
                .TransformEnvironmentValue(value)
            })
            .toMap
        )
    override val transformInput
        : zio.aws.sagemaker.model.TransformInput.ReadOnly =
      zio.aws.sagemaker.model.TransformInput.wrap(impl.transformInput())
    override val transformOutput
        : zio.aws.sagemaker.model.TransformOutput.ReadOnly =
      zio.aws.sagemaker.model.TransformOutput.wrap(impl.transformOutput())
    override val dataCaptureConfig
        : Optional[zio.aws.sagemaker.model.BatchDataCaptureConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataCaptureConfig())
        .map(value =>
          zio.aws.sagemaker.model.BatchDataCaptureConfig.wrap(value)
        )
    override val transformResources
        : zio.aws.sagemaker.model.TransformResources.ReadOnly =
      zio.aws.sagemaker.model.TransformResources.wrap(impl.transformResources())
    override val dataProcessing
        : Optional[zio.aws.sagemaker.model.DataProcessing.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataProcessing())
        .map(value => zio.aws.sagemaker.model.DataProcessing.wrap(value))
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val experimentConfig
        : Optional[zio.aws.sagemaker.model.ExperimentConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.experimentConfig())
        .map(value => zio.aws.sagemaker.model.ExperimentConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateTransformJobRequest
  ): zio.aws.sagemaker.model.CreateTransformJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
