package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  EndpointName,
  InferenceExperimentName,
  InferenceExperimentDescription,
  KmsKeyId
}
import scala.jdk.CollectionConverters._
final case class CreateInferenceExperimentRequest(
    name: InferenceExperimentName,
    `type`: zio.aws.sagemaker.model.InferenceExperimentType,
    schedule: Optional[zio.aws.sagemaker.model.InferenceExperimentSchedule] =
      Optional.Absent,
    description: Optional[InferenceExperimentDescription] = Optional.Absent,
    roleArn: RoleArn,
    endpointName: EndpointName,
    modelVariants: Iterable[zio.aws.sagemaker.model.ModelVariantConfig],
    dataStorageConfig: Optional[
      zio.aws.sagemaker.model.InferenceExperimentDataStorageConfig
    ] = Optional.Absent,
    shadowModeConfig: zio.aws.sagemaker.model.ShadowModeConfig,
    kmsKey: Optional[KmsKeyId] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateInferenceExperimentRequest = {
    import CreateInferenceExperimentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateInferenceExperimentRequest
      .builder()
      .name(InferenceExperimentName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(
        description.map(value =>
          InferenceExperimentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .endpointName(EndpointName.unwrap(endpointName): java.lang.String)
      .modelVariants(modelVariants.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(dataStorageConfig.map(value => value.buildAwsValue()))(
        _.dataStorageConfig
      )
      .shadowModeConfig(shadowModeConfig.buildAwsValue())
      .optionallyWith(
        kmsKey.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateInferenceExperimentRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateInferenceExperimentRequest
      .wrap(buildAwsValue())
}
object CreateInferenceExperimentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateInferenceExperimentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateInferenceExperimentRequest =
      zio.aws.sagemaker.model.CreateInferenceExperimentRequest(
        name,
        `type`,
        schedule.map(value => value.asEditable),
        description.map(value => value),
        roleArn,
        endpointName,
        modelVariants.map { item =>
          item.asEditable
        },
        dataStorageConfig.map(value => value.asEditable),
        shadowModeConfig.asEditable,
        kmsKey.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: InferenceExperimentName
    def `type`: zio.aws.sagemaker.model.InferenceExperimentType
    def schedule
        : Optional[zio.aws.sagemaker.model.InferenceExperimentSchedule.ReadOnly]
    def description: Optional[InferenceExperimentDescription]
    def roleArn: RoleArn
    def endpointName: EndpointName
    def modelVariants: List[zio.aws.sagemaker.model.ModelVariantConfig.ReadOnly]
    def dataStorageConfig: Optional[
      zio.aws.sagemaker.model.InferenceExperimentDataStorageConfig.ReadOnly
    ]
    def shadowModeConfig: zio.aws.sagemaker.model.ShadowModeConfig.ReadOnly
    def kmsKey: Optional[KmsKeyId]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, InferenceExperimentName] = ZIO.succeed(name)
    def getType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.InferenceExperimentType] =
      ZIO.succeed(`type`)
    def getSchedule: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.InferenceExperimentSchedule.ReadOnly
    ] = AwsError.unwrapOptionField("schedule", schedule)
    def getDescription: ZIO[Any, AwsError, InferenceExperimentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getEndpointName: ZIO[Any, Nothing, EndpointName] =
      ZIO.succeed(endpointName)
    def getModelVariants: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.ModelVariantConfig.ReadOnly
    ]] = ZIO.succeed(modelVariants)
    def getDataStorageConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.InferenceExperimentDataStorageConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dataStorageConfig", dataStorageConfig)
    def getShadowModeConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ShadowModeConfig.ReadOnly] =
      ZIO.succeed(shadowModeConfig)
    def getKmsKey: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateInferenceExperimentRequest
  ) extends zio.aws.sagemaker.model.CreateInferenceExperimentRequest.ReadOnly {
    override val name: InferenceExperimentName =
      zio.aws.sagemaker.model.primitives.InferenceExperimentName(impl.name())
    override val `type`: zio.aws.sagemaker.model.InferenceExperimentType =
      zio.aws.sagemaker.model.InferenceExperimentType.wrap(impl.`type`())
    override val schedule: Optional[
      zio.aws.sagemaker.model.InferenceExperimentSchedule.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.schedule())
      .map(value =>
        zio.aws.sagemaker.model.InferenceExperimentSchedule.wrap(value)
      )
    override val description: Optional[InferenceExperimentDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.sagemaker.model.primitives
            .InferenceExperimentDescription(value)
        )
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val endpointName: EndpointName =
      zio.aws.sagemaker.model.primitives.EndpointName(impl.endpointName())
    override val modelVariants
        : List[zio.aws.sagemaker.model.ModelVariantConfig.ReadOnly] = impl
      .modelVariants()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.ModelVariantConfig.wrap(item)
      }
      .toList
    override val dataStorageConfig: Optional[
      zio.aws.sagemaker.model.InferenceExperimentDataStorageConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataStorageConfig())
      .map(value =>
        zio.aws.sagemaker.model.InferenceExperimentDataStorageConfig.wrap(value)
      )
    override val shadowModeConfig
        : zio.aws.sagemaker.model.ShadowModeConfig.ReadOnly =
      zio.aws.sagemaker.model.ShadowModeConfig.wrap(impl.shadowModeConfig())
    override val kmsKey: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKey())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateInferenceExperimentRequest
  ): zio.aws.sagemaker.model.CreateInferenceExperimentRequest.ReadOnly =
    new Wrapper(impl)
}
