package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{ClientId, CognitoUserPool}
import scala.jdk.CollectionConverters._
final case class CognitoConfig(userPool: CognitoUserPool, clientId: ClientId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CognitoConfig = {
    import CognitoConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CognitoConfig
      .builder()
      .userPool(CognitoUserPool.unwrap(userPool): java.lang.String)
      .clientId(ClientId.unwrap(clientId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CognitoConfig.ReadOnly =
    zio.aws.sagemaker.model.CognitoConfig.wrap(buildAwsValue())
}
object CognitoConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CognitoConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CognitoConfig =
      zio.aws.sagemaker.model.CognitoConfig(userPool, clientId)
    def userPool: CognitoUserPool
    def clientId: ClientId
    def getUserPool: ZIO[Any, Nothing, CognitoUserPool] = ZIO.succeed(userPool)
    def getClientId: ZIO[Any, Nothing, ClientId] = ZIO.succeed(clientId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CognitoConfig
  ) extends zio.aws.sagemaker.model.CognitoConfig.ReadOnly {
    override val userPool: CognitoUserPool =
      zio.aws.sagemaker.model.primitives.CognitoUserPool(impl.userPool())
    override val clientId: ClientId =
      zio.aws.sagemaker.model.primitives.ClientId(impl.clientId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CognitoConfig
  ): zio.aws.sagemaker.model.CognitoConfig.ReadOnly = new Wrapper(impl)
}
