package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  ImageDisplayName,
  ImageDeleteProperty,
  RoleArn,
  ImageDescription,
  ImageName
}
import scala.jdk.CollectionConverters._
final case class UpdateImageRequest(
    deleteProperties: Optional[Iterable[ImageDeleteProperty]] = Optional.Absent,
    description: Optional[ImageDescription] = Optional.Absent,
    displayName: Optional[ImageDisplayName] = Optional.Absent,
    imageName: ImageName,
    roleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateImageRequest = {
    import UpdateImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateImageRequest
      .builder()
      .optionallyWith(
        deleteProperties.map(value =>
          value.map { item =>
            ImageDeleteProperty.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.deleteProperties)
      .optionallyWith(
        description.map(value =>
          ImageDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        displayName.map(value =>
          ImageDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .imageName(ImageName.unwrap(imageName): java.lang.String)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateImageRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateImageRequest.wrap(buildAwsValue())
}
object UpdateImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateImageRequest =
      zio.aws.sagemaker.model.UpdateImageRequest(
        deleteProperties.map(value => value),
        description.map(value => value),
        displayName.map(value => value),
        imageName,
        roleArn.map(value => value)
      )
    def deleteProperties: Optional[List[ImageDeleteProperty]]
    def description: Optional[ImageDescription]
    def displayName: Optional[ImageDisplayName]
    def imageName: ImageName
    def roleArn: Optional[RoleArn]
    def getDeleteProperties: ZIO[Any, AwsError, List[ImageDeleteProperty]] =
      AwsError.unwrapOptionField("deleteProperties", deleteProperties)
    def getDescription: ZIO[Any, AwsError, ImageDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, ImageDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getImageName: ZIO[Any, Nothing, ImageName] = ZIO.succeed(imageName)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateImageRequest
  ) extends zio.aws.sagemaker.model.UpdateImageRequest.ReadOnly {
    override val deleteProperties: Optional[List[ImageDeleteProperty]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteProperties())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.ImageDeleteProperty(item)
          }.toList
        )
    override val description: Optional[ImageDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.sagemaker.model.primitives.ImageDescription(value))
    override val displayName: Optional[ImageDisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.sagemaker.model.primitives.ImageDisplayName(value))
    override val imageName: ImageName =
      zio.aws.sagemaker.model.primitives.ImageName(impl.imageName())
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateImageRequest
  ): zio.aws.sagemaker.model.UpdateImageRequest.ReadOnly = new Wrapper(impl)
}
