package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.InferenceExperimentArn
import scala.jdk.CollectionConverters._
final case class StopInferenceExperimentResponse(
    inferenceExperimentArn: InferenceExperimentArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.StopInferenceExperimentResponse = {
    import StopInferenceExperimentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.StopInferenceExperimentResponse
      .builder()
      .inferenceExperimentArn(
        InferenceExperimentArn.unwrap(inferenceExperimentArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.StopInferenceExperimentResponse.ReadOnly =
    zio.aws.sagemaker.model.StopInferenceExperimentResponse
      .wrap(buildAwsValue())
}
object StopInferenceExperimentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.StopInferenceExperimentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.StopInferenceExperimentResponse =
      zio.aws.sagemaker.model
        .StopInferenceExperimentResponse(inferenceExperimentArn)
    def inferenceExperimentArn: InferenceExperimentArn
    def getInferenceExperimentArn: ZIO[Any, Nothing, InferenceExperimentArn] =
      ZIO.succeed(inferenceExperimentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.StopInferenceExperimentResponse
  ) extends zio.aws.sagemaker.model.StopInferenceExperimentResponse.ReadOnly {
    override val inferenceExperimentArn: InferenceExperimentArn =
      zio.aws.sagemaker.model.primitives
        .InferenceExperimentArn(impl.inferenceExperimentArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.StopInferenceExperimentResponse
  ): zio.aws.sagemaker.model.StopInferenceExperimentResponse.ReadOnly =
    new Wrapper(impl)
}
