package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait RecordWrapper {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.RecordWrapper
}
object RecordWrapper {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.RecordWrapper
  ): zio.aws.sagemaker.model.RecordWrapper = value match {
    case software.amazon.awssdk.services.sagemaker.model.RecordWrapper.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.RecordWrapper.NONE =>
      val r = None
      r
    case software.amazon.awssdk.services.sagemaker.model.RecordWrapper.RECORD_IO =>
      val r = RecordIO
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.RecordWrapper {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RecordWrapper =
      software.amazon.awssdk.services.sagemaker.model.RecordWrapper.UNKNOWN_TO_SDK_VERSION
  }
  case object None extends zio.aws.sagemaker.model.RecordWrapper {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RecordWrapper =
      software.amazon.awssdk.services.sagemaker.model.RecordWrapper.NONE
  }
  case object RecordIO extends zio.aws.sagemaker.model.RecordWrapper {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RecordWrapper =
      software.amazon.awssdk.services.sagemaker.model.RecordWrapper.RECORD_IO
  }
}
