package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.KmsKeyId
import scala.jdk.CollectionConverters._
final case class RecommendationJobOutputConfig(
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    compiledOutputConfig: Optional[
      zio.aws.sagemaker.model.RecommendationJobCompiledOutputConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RecommendationJobOutputConfig = {
    import RecommendationJobOutputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RecommendationJobOutputConfig
      .builder()
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(compiledOutputConfig.map(value => value.buildAwsValue()))(
        _.compiledOutputConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.RecommendationJobOutputConfig.ReadOnly =
    zio.aws.sagemaker.model.RecommendationJobOutputConfig.wrap(buildAwsValue())
}
object RecommendationJobOutputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RecommendationJobOutputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RecommendationJobOutputConfig =
      zio.aws.sagemaker.model.RecommendationJobOutputConfig(
        kmsKeyId.map(value => value),
        compiledOutputConfig.map(value => value.asEditable)
      )
    def kmsKeyId: Optional[KmsKeyId]
    def compiledOutputConfig: Optional[
      zio.aws.sagemaker.model.RecommendationJobCompiledOutputConfig.ReadOnly
    ]
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getCompiledOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RecommendationJobCompiledOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField("compiledOutputConfig", compiledOutputConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationJobOutputConfig
  ) extends zio.aws.sagemaker.model.RecommendationJobOutputConfig.ReadOnly {
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val compiledOutputConfig: Optional[
      zio.aws.sagemaker.model.RecommendationJobCompiledOutputConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.compiledOutputConfig())
      .map(value =>
        zio.aws.sagemaker.model.RecommendationJobCompiledOutputConfig
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationJobOutputConfig
  ): zio.aws.sagemaker.model.RecommendationJobOutputConfig.ReadOnly =
    new Wrapper(impl)
}
