package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  PipelineDescription,
  Timestamp,
  PipelineArn,
  PipelineName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Pipeline(
    pipelineArn: Optional[PipelineArn] = Optional.Absent,
    pipelineName: Optional[PipelineName] = Optional.Absent,
    pipelineDisplayName: Optional[PipelineName] = Optional.Absent,
    pipelineDescription: Optional[PipelineDescription] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    pipelineStatus: Optional[zio.aws.sagemaker.model.PipelineStatus] =
      Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    lastRunTime: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[zio.aws.sagemaker.model.UserContext] = Optional.Absent,
    lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext] =
      Optional.Absent,
    parallelismConfiguration: Optional[
      zio.aws.sagemaker.model.ParallelismConfiguration
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.Pipeline = {
    import Pipeline.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Pipeline
      .builder()
      .optionallyWith(
        pipelineArn.map(value => PipelineArn.unwrap(value): java.lang.String)
      )(_.pipelineArn)
      .optionallyWith(
        pipelineName.map(value => PipelineName.unwrap(value): java.lang.String)
      )(_.pipelineName)
      .optionallyWith(
        pipelineDisplayName.map(value =>
          PipelineName.unwrap(value): java.lang.String
        )
      )(_.pipelineDisplayName)
      .optionallyWith(
        pipelineDescription.map(value =>
          PipelineDescription.unwrap(value): java.lang.String
        )
      )(_.pipelineDescription)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(pipelineStatus.map(value => value.unwrap))(
        _.pipelineStatus
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        lastRunTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastRunTime)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .optionallyWith(
        parallelismConfiguration.map(value => value.buildAwsValue())
      )(_.parallelismConfiguration)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Pipeline.ReadOnly =
    zio.aws.sagemaker.model.Pipeline.wrap(buildAwsValue())
}
object Pipeline {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.Pipeline
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Pipeline =
      zio.aws.sagemaker.model.Pipeline(
        pipelineArn.map(value => value),
        pipelineName.map(value => value),
        pipelineDisplayName.map(value => value),
        pipelineDescription.map(value => value),
        roleArn.map(value => value),
        pipelineStatus.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        lastRunTime.map(value => value),
        createdBy.map(value => value.asEditable),
        lastModifiedBy.map(value => value.asEditable),
        parallelismConfiguration.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def pipelineArn: Optional[PipelineArn]
    def pipelineName: Optional[PipelineName]
    def pipelineDisplayName: Optional[PipelineName]
    def pipelineDescription: Optional[PipelineDescription]
    def roleArn: Optional[RoleArn]
    def pipelineStatus: Optional[zio.aws.sagemaker.model.PipelineStatus]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def lastRunTime: Optional[Timestamp]
    def createdBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def parallelismConfiguration
        : Optional[zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getPipelineArn: ZIO[Any, AwsError, PipelineArn] =
      AwsError.unwrapOptionField("pipelineArn", pipelineArn)
    def getPipelineName: ZIO[Any, AwsError, PipelineName] =
      AwsError.unwrapOptionField("pipelineName", pipelineName)
    def getPipelineDisplayName: ZIO[Any, AwsError, PipelineName] =
      AwsError.unwrapOptionField("pipelineDisplayName", pipelineDisplayName)
    def getPipelineDescription: ZIO[Any, AwsError, PipelineDescription] =
      AwsError.unwrapOptionField("pipelineDescription", pipelineDescription)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getPipelineStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.PipelineStatus] =
      AwsError.unwrapOptionField("pipelineStatus", pipelineStatus)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastRunTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastRunTime", lastRunTime)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getParallelismConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "parallelismConfiguration",
      parallelismConfiguration
    )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Pipeline
  ) extends zio.aws.sagemaker.model.Pipeline.ReadOnly {
    override val pipelineArn: Optional[PipelineArn] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineArn())
      .map(value => zio.aws.sagemaker.model.primitives.PipelineArn(value))
    override val pipelineName: Optional[PipelineName] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineName())
      .map(value => zio.aws.sagemaker.model.primitives.PipelineName(value))
    override val pipelineDisplayName: Optional[PipelineName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineDisplayName())
        .map(value => zio.aws.sagemaker.model.primitives.PipelineName(value))
    override val pipelineDescription: Optional[PipelineDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineDescription())
        .map(value =>
          zio.aws.sagemaker.model.primitives.PipelineDescription(value)
        )
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val pipelineStatus
        : Optional[zio.aws.sagemaker.model.PipelineStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineStatus())
        .map(value => zio.aws.sagemaker.model.PipelineStatus.wrap(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastRunTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastRunTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val lastModifiedBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val parallelismConfiguration
        : Optional[zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parallelismConfiguration())
        .map(value =>
          zio.aws.sagemaker.model.ParallelismConfiguration.wrap(value)
        )
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Pipeline
  ): zio.aws.sagemaker.model.Pipeline.ReadOnly = new Wrapper(impl)
}
