package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  Integer,
  ModelCardExportJobArn,
  EntityName
}
import scala.jdk.CollectionConverters._
final case class ModelCardExportJobSummary(
    modelCardExportJobName: EntityName,
    modelCardExportJobArn: ModelCardExportJobArn,
    status: zio.aws.sagemaker.model.ModelCardExportJobStatus,
    modelCardName: EntityName,
    modelCardVersion: Integer,
    createdAt: Timestamp,
    lastModifiedAt: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobSummary = {
    import ModelCardExportJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobSummary
      .builder()
      .modelCardExportJobName(
        EntityName.unwrap(modelCardExportJobName): java.lang.String
      )
      .modelCardExportJobArn(
        ModelCardExportJobArn.unwrap(modelCardExportJobArn): java.lang.String
      )
      .status(status.unwrap)
      .modelCardName(EntityName.unwrap(modelCardName): java.lang.String)
      .modelCardVersion(modelCardVersion: java.lang.Integer)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .lastModifiedAt(Timestamp.unwrap(lastModifiedAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelCardExportJobSummary.ReadOnly =
    zio.aws.sagemaker.model.ModelCardExportJobSummary.wrap(buildAwsValue())
}
object ModelCardExportJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelCardExportJobSummary =
      zio.aws.sagemaker.model.ModelCardExportJobSummary(
        modelCardExportJobName,
        modelCardExportJobArn,
        status,
        modelCardName,
        modelCardVersion,
        createdAt,
        lastModifiedAt
      )
    def modelCardExportJobName: EntityName
    def modelCardExportJobArn: ModelCardExportJobArn
    def status: zio.aws.sagemaker.model.ModelCardExportJobStatus
    def modelCardName: EntityName
    def modelCardVersion: Integer
    def createdAt: Timestamp
    def lastModifiedAt: Timestamp
    def getModelCardExportJobName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(modelCardExportJobName)
    def getModelCardExportJobArn: ZIO[Any, Nothing, ModelCardExportJobArn] =
      ZIO.succeed(modelCardExportJobArn)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ModelCardExportJobStatus] =
      ZIO.succeed(status)
    def getModelCardName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(modelCardName)
    def getModelCardVersion: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(modelCardVersion)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getLastModifiedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobSummary
  ) extends zio.aws.sagemaker.model.ModelCardExportJobSummary.ReadOnly {
    override val modelCardExportJobName: EntityName =
      zio.aws.sagemaker.model.primitives
        .EntityName(impl.modelCardExportJobName())
    override val modelCardExportJobArn: ModelCardExportJobArn =
      zio.aws.sagemaker.model.primitives
        .ModelCardExportJobArn(impl.modelCardExportJobArn())
    override val status: zio.aws.sagemaker.model.ModelCardExportJobStatus =
      zio.aws.sagemaker.model.ModelCardExportJobStatus.wrap(impl.status())
    override val modelCardName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.modelCardName())
    override val modelCardVersion: Integer = impl.modelCardVersion(): Integer
    override val createdAt: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.createdAt())
    override val lastModifiedAt: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.lastModifiedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobSummary
  ): zio.aws.sagemaker.model.ModelCardExportJobSummary.ReadOnly = new Wrapper(
    impl
  )
}
