package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  KmsKeyId,
  OptionalVolumeSizeInGB,
  TrainingInstanceCount
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class HyperParameterTuningResourceConfig(
    instanceType: Optional[zio.aws.sagemaker.model.TrainingInstanceType] =
      Optional.Absent,
    instanceCount: Optional[TrainingInstanceCount] = Optional.Absent,
    volumeSizeInGB: Optional[OptionalVolumeSizeInGB] = Optional.Absent,
    volumeKmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    allocationStrategy: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningAllocationStrategy
    ] = Optional.Absent,
    instanceConfigs: Optional[
      Iterable[zio.aws.sagemaker.model.HyperParameterTuningInstanceConfig]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningResourceConfig = {
    import HyperParameterTuningResourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningResourceConfig
      .builder()
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        instanceCount.map(value => TrainingInstanceCount.unwrap(value): Integer)
      )(_.instanceCount)
      .optionallyWith(
        volumeSizeInGB.map(value =>
          OptionalVolumeSizeInGB.unwrap(value): Integer
        )
      )(_.volumeSizeInGB)
      .optionallyWith(
        volumeKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.volumeKmsKeyId)
      .optionallyWith(allocationStrategy.map(value => value.unwrap))(
        _.allocationStrategy
      )
      .optionallyWith(
        instanceConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceConfigs)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.HyperParameterTuningResourceConfig.ReadOnly =
    zio.aws.sagemaker.model.HyperParameterTuningResourceConfig
      .wrap(buildAwsValue())
}
object HyperParameterTuningResourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningResourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.HyperParameterTuningResourceConfig =
      zio.aws.sagemaker.model.HyperParameterTuningResourceConfig(
        instanceType.map(value => value),
        instanceCount.map(value => value),
        volumeSizeInGB.map(value => value),
        volumeKmsKeyId.map(value => value),
        allocationStrategy.map(value => value),
        instanceConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def instanceType: Optional[zio.aws.sagemaker.model.TrainingInstanceType]
    def instanceCount: Optional[TrainingInstanceCount]
    def volumeSizeInGB: Optional[OptionalVolumeSizeInGB]
    def volumeKmsKeyId: Optional[KmsKeyId]
    def allocationStrategy: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningAllocationStrategy
    ]
    def instanceConfigs: Optional[
      List[zio.aws.sagemaker.model.HyperParameterTuningInstanceConfig.ReadOnly]
    ]
    def getInstanceType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TrainingInstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getInstanceCount: ZIO[Any, AwsError, TrainingInstanceCount] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getVolumeSizeInGB: ZIO[Any, AwsError, OptionalVolumeSizeInGB] =
      AwsError.unwrapOptionField("volumeSizeInGB", volumeSizeInGB)
    def getVolumeKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("volumeKmsKeyId", volumeKmsKeyId)
    def getAllocationStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTuningAllocationStrategy
    ] = AwsError.unwrapOptionField("allocationStrategy", allocationStrategy)
    def getInstanceConfigs: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.HyperParameterTuningInstanceConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceConfigs", instanceConfigs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningResourceConfig
  ) extends zio.aws.sagemaker.model.HyperParameterTuningResourceConfig.ReadOnly {
    override val instanceType
        : Optional[zio.aws.sagemaker.model.TrainingInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.sagemaker.model.TrainingInstanceType.wrap(value))
    override val instanceCount: Optional[TrainingInstanceCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceCount())
        .map(value =>
          zio.aws.sagemaker.model.primitives.TrainingInstanceCount(value)
        )
    override val volumeSizeInGB: Optional[OptionalVolumeSizeInGB] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeSizeInGB())
        .map(value =>
          zio.aws.sagemaker.model.primitives.OptionalVolumeSizeInGB(value)
        )
    override val volumeKmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeKmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val allocationStrategy: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningAllocationStrategy
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.allocationStrategy())
      .map(value =>
        zio.aws.sagemaker.model.HyperParameterTuningAllocationStrategy
          .wrap(value)
      )
    override val instanceConfigs: Optional[
      List[zio.aws.sagemaker.model.HyperParameterTuningInstanceConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.HyperParameterTuningInstanceConfig.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningResourceConfig
  ): zio.aws.sagemaker.model.HyperParameterTuningResourceConfig.ReadOnly =
    new Wrapper(impl)
}
