package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  TaskKeyword,
  NumberOfHumanWorkersPerDataObject,
  WorkteamArn,
  TaskTitle,
  TaskDescription,
  TaskTimeLimitInSeconds,
  MaxConcurrentTaskCount,
  LambdaFunctionArn,
  TaskAvailabilityLifetimeInSeconds
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class HumanTaskConfig(
    workteamArn: WorkteamArn,
    uiConfig: zio.aws.sagemaker.model.UiConfig,
    preHumanTaskLambdaArn: LambdaFunctionArn,
    taskKeywords: Optional[Iterable[TaskKeyword]] = Optional.Absent,
    taskTitle: TaskTitle,
    taskDescription: TaskDescription,
    numberOfHumanWorkersPerDataObject: NumberOfHumanWorkersPerDataObject,
    taskTimeLimitInSeconds: TaskTimeLimitInSeconds,
    taskAvailabilityLifetimeInSeconds: Optional[
      TaskAvailabilityLifetimeInSeconds
    ] = Optional.Absent,
    maxConcurrentTaskCount: Optional[MaxConcurrentTaskCount] = Optional.Absent,
    annotationConsolidationConfig: zio.aws.sagemaker.model.AnnotationConsolidationConfig,
    publicWorkforceTaskPrice: Optional[
      zio.aws.sagemaker.model.PublicWorkforceTaskPrice
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HumanTaskConfig = {
    import HumanTaskConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HumanTaskConfig
      .builder()
      .workteamArn(WorkteamArn.unwrap(workteamArn): java.lang.String)
      .uiConfig(uiConfig.buildAwsValue())
      .preHumanTaskLambdaArn(
        LambdaFunctionArn.unwrap(preHumanTaskLambdaArn): java.lang.String
      )
      .optionallyWith(
        taskKeywords.map(value =>
          value.map { item =>
            TaskKeyword.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.taskKeywords)
      .taskTitle(TaskTitle.unwrap(taskTitle): java.lang.String)
      .taskDescription(
        TaskDescription.unwrap(taskDescription): java.lang.String
      )
      .numberOfHumanWorkersPerDataObject(
        NumberOfHumanWorkersPerDataObject.unwrap(
          numberOfHumanWorkersPerDataObject
        ): Integer
      )
      .taskTimeLimitInSeconds(
        TaskTimeLimitInSeconds.unwrap(taskTimeLimitInSeconds): Integer
      )
      .optionallyWith(
        taskAvailabilityLifetimeInSeconds.map(value =>
          TaskAvailabilityLifetimeInSeconds.unwrap(value): Integer
        )
      )(_.taskAvailabilityLifetimeInSeconds)
      .optionallyWith(
        maxConcurrentTaskCount.map(value =>
          MaxConcurrentTaskCount.unwrap(value): Integer
        )
      )(_.maxConcurrentTaskCount)
      .annotationConsolidationConfig(
        annotationConsolidationConfig.buildAwsValue()
      )
      .optionallyWith(
        publicWorkforceTaskPrice.map(value => value.buildAwsValue())
      )(_.publicWorkforceTaskPrice)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.HumanTaskConfig.ReadOnly =
    zio.aws.sagemaker.model.HumanTaskConfig.wrap(buildAwsValue())
}
object HumanTaskConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HumanTaskConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.HumanTaskConfig =
      zio.aws.sagemaker.model.HumanTaskConfig(
        workteamArn,
        uiConfig.asEditable,
        preHumanTaskLambdaArn,
        taskKeywords.map(value => value),
        taskTitle,
        taskDescription,
        numberOfHumanWorkersPerDataObject,
        taskTimeLimitInSeconds,
        taskAvailabilityLifetimeInSeconds.map(value => value),
        maxConcurrentTaskCount.map(value => value),
        annotationConsolidationConfig.asEditable,
        publicWorkforceTaskPrice.map(value => value.asEditable)
      )
    def workteamArn: WorkteamArn
    def uiConfig: zio.aws.sagemaker.model.UiConfig.ReadOnly
    def preHumanTaskLambdaArn: LambdaFunctionArn
    def taskKeywords: Optional[List[TaskKeyword]]
    def taskTitle: TaskTitle
    def taskDescription: TaskDescription
    def numberOfHumanWorkersPerDataObject: NumberOfHumanWorkersPerDataObject
    def taskTimeLimitInSeconds: TaskTimeLimitInSeconds
    def taskAvailabilityLifetimeInSeconds
        : Optional[TaskAvailabilityLifetimeInSeconds]
    def maxConcurrentTaskCount: Optional[MaxConcurrentTaskCount]
    def annotationConsolidationConfig
        : zio.aws.sagemaker.model.AnnotationConsolidationConfig.ReadOnly
    def publicWorkforceTaskPrice
        : Optional[zio.aws.sagemaker.model.PublicWorkforceTaskPrice.ReadOnly]
    def getWorkteamArn: ZIO[Any, Nothing, WorkteamArn] =
      ZIO.succeed(workteamArn)
    def getUiConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.UiConfig.ReadOnly] =
      ZIO.succeed(uiConfig)
    def getPreHumanTaskLambdaArn: ZIO[Any, Nothing, LambdaFunctionArn] =
      ZIO.succeed(preHumanTaskLambdaArn)
    def getTaskKeywords: ZIO[Any, AwsError, List[TaskKeyword]] =
      AwsError.unwrapOptionField("taskKeywords", taskKeywords)
    def getTaskTitle: ZIO[Any, Nothing, TaskTitle] = ZIO.succeed(taskTitle)
    def getTaskDescription: ZIO[Any, Nothing, TaskDescription] =
      ZIO.succeed(taskDescription)
    def getNumberOfHumanWorkersPerDataObject
        : ZIO[Any, Nothing, NumberOfHumanWorkersPerDataObject] =
      ZIO.succeed(numberOfHumanWorkersPerDataObject)
    def getTaskTimeLimitInSeconds: ZIO[Any, Nothing, TaskTimeLimitInSeconds] =
      ZIO.succeed(taskTimeLimitInSeconds)
    def getTaskAvailabilityLifetimeInSeconds
        : ZIO[Any, AwsError, TaskAvailabilityLifetimeInSeconds] =
      AwsError.unwrapOptionField(
        "taskAvailabilityLifetimeInSeconds",
        taskAvailabilityLifetimeInSeconds
      )
    def getMaxConcurrentTaskCount: ZIO[Any, AwsError, MaxConcurrentTaskCount] =
      AwsError.unwrapOptionField(
        "maxConcurrentTaskCount",
        maxConcurrentTaskCount
      )
    def getAnnotationConsolidationConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.AnnotationConsolidationConfig.ReadOnly
    ] = ZIO.succeed(annotationConsolidationConfig)
    def getPublicWorkforceTaskPrice: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.PublicWorkforceTaskPrice.ReadOnly
    ] = AwsError.unwrapOptionField(
      "publicWorkforceTaskPrice",
      publicWorkforceTaskPrice
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HumanTaskConfig
  ) extends zio.aws.sagemaker.model.HumanTaskConfig.ReadOnly {
    override val workteamArn: WorkteamArn =
      zio.aws.sagemaker.model.primitives.WorkteamArn(impl.workteamArn())
    override val uiConfig: zio.aws.sagemaker.model.UiConfig.ReadOnly =
      zio.aws.sagemaker.model.UiConfig.wrap(impl.uiConfig())
    override val preHumanTaskLambdaArn: LambdaFunctionArn =
      zio.aws.sagemaker.model.primitives
        .LambdaFunctionArn(impl.preHumanTaskLambdaArn())
    override val taskKeywords: Optional[List[TaskKeyword]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskKeywords())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.TaskKeyword(item)
          }.toList
        )
    override val taskTitle: TaskTitle =
      zio.aws.sagemaker.model.primitives.TaskTitle(impl.taskTitle())
    override val taskDescription: TaskDescription =
      zio.aws.sagemaker.model.primitives.TaskDescription(impl.taskDescription())
    override val numberOfHumanWorkersPerDataObject
        : NumberOfHumanWorkersPerDataObject =
      zio.aws.sagemaker.model.primitives.NumberOfHumanWorkersPerDataObject(
        impl.numberOfHumanWorkersPerDataObject()
      )
    override val taskTimeLimitInSeconds: TaskTimeLimitInSeconds =
      zio.aws.sagemaker.model.primitives
        .TaskTimeLimitInSeconds(impl.taskTimeLimitInSeconds())
    override val taskAvailabilityLifetimeInSeconds
        : Optional[TaskAvailabilityLifetimeInSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.taskAvailabilityLifetimeInSeconds())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .TaskAvailabilityLifetimeInSeconds(value)
      )
    override val maxConcurrentTaskCount: Optional[MaxConcurrentTaskCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConcurrentTaskCount())
        .map(value =>
          zio.aws.sagemaker.model.primitives.MaxConcurrentTaskCount(value)
        )
    override val annotationConsolidationConfig
        : zio.aws.sagemaker.model.AnnotationConsolidationConfig.ReadOnly =
      zio.aws.sagemaker.model.AnnotationConsolidationConfig
        .wrap(impl.annotationConsolidationConfig())
    override val publicWorkforceTaskPrice
        : Optional[zio.aws.sagemaker.model.PublicWorkforceTaskPrice.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicWorkforceTaskPrice())
        .map(value =>
          zio.aws.sagemaker.model.PublicWorkforceTaskPrice.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HumanTaskConfig
  ): zio.aws.sagemaker.model.HumanTaskConfig.ReadOnly = new Wrapper(impl)
}
