package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeSubscribedWorkteamResponse(
    subscribedWorkteam: zio.aws.sagemaker.model.SubscribedWorkteam
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamResponse = {
    import DescribeSubscribedWorkteamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamResponse
      .builder()
      .subscribedWorkteam(subscribedWorkteam.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeSubscribedWorkteamResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeSubscribedWorkteamResponse
      .wrap(buildAwsValue())
}
object DescribeSubscribedWorkteamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeSubscribedWorkteamResponse =
      zio.aws.sagemaker.model
        .DescribeSubscribedWorkteamResponse(subscribedWorkteam.asEditable)
    def subscribedWorkteam: zio.aws.sagemaker.model.SubscribedWorkteam.ReadOnly
    def getSubscribedWorkteam: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.SubscribedWorkteam.ReadOnly
    ] = ZIO.succeed(subscribedWorkteam)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamResponse
  ) extends zio.aws.sagemaker.model.DescribeSubscribedWorkteamResponse.ReadOnly {
    override val subscribedWorkteam
        : zio.aws.sagemaker.model.SubscribedWorkteam.ReadOnly =
      zio.aws.sagemaker.model.SubscribedWorkteam.wrap(impl.subscribedWorkteam())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamResponse
  ): zio.aws.sagemaker.model.DescribeSubscribedWorkteamResponse.ReadOnly =
    new Wrapper(impl)
}
