package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  FailureReason,
  Timestamp,
  HyperParameterTuningJobArn,
  HyperParameterTuningJobName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeHyperParameterTuningJobResponse(
    hyperParameterTuningJobName: HyperParameterTuningJobName,
    hyperParameterTuningJobArn: HyperParameterTuningJobArn,
    hyperParameterTuningJobConfig: zio.aws.sagemaker.model.HyperParameterTuningJobConfig,
    trainingJobDefinition: Optional[
      zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition
    ] = Optional.Absent,
    trainingJobDefinitions: Optional[
      Iterable[zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition]
    ] = Optional.Absent,
    hyperParameterTuningJobStatus: zio.aws.sagemaker.model.HyperParameterTuningJobStatus,
    creationTime: Timestamp,
    hyperParameterTuningEndTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    trainingJobStatusCounters: zio.aws.sagemaker.model.TrainingJobStatusCounters,
    objectiveStatusCounters: zio.aws.sagemaker.model.ObjectiveStatusCounters,
    bestTrainingJob: Optional[
      zio.aws.sagemaker.model.HyperParameterTrainingJobSummary
    ] = Optional.Absent,
    overallBestTrainingJob: Optional[
      zio.aws.sagemaker.model.HyperParameterTrainingJobSummary
    ] = Optional.Absent,
    warmStartConfig: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig
    ] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobResponse = {
    import DescribeHyperParameterTuningJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobResponse
      .builder()
      .hyperParameterTuningJobName(
        HyperParameterTuningJobName.unwrap(
          hyperParameterTuningJobName
        ): java.lang.String
      )
      .hyperParameterTuningJobArn(
        HyperParameterTuningJobArn.unwrap(
          hyperParameterTuningJobArn
        ): java.lang.String
      )
      .hyperParameterTuningJobConfig(
        hyperParameterTuningJobConfig.buildAwsValue()
      )
      .optionallyWith(
        trainingJobDefinition.map(value => value.buildAwsValue())
      )(_.trainingJobDefinition)
      .optionallyWith(
        trainingJobDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.trainingJobDefinitions)
      .hyperParameterTuningJobStatus(hyperParameterTuningJobStatus.unwrap)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(
        hyperParameterTuningEndTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.hyperParameterTuningEndTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .trainingJobStatusCounters(trainingJobStatusCounters.buildAwsValue())
      .objectiveStatusCounters(objectiveStatusCounters.buildAwsValue())
      .optionallyWith(bestTrainingJob.map(value => value.buildAwsValue()))(
        _.bestTrainingJob
      )
      .optionallyWith(
        overallBestTrainingJob.map(value => value.buildAwsValue())
      )(_.overallBestTrainingJob)
      .optionallyWith(warmStartConfig.map(value => value.buildAwsValue()))(
        _.warmStartConfig
      )
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeHyperParameterTuningJobResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeHyperParameterTuningJobResponse
      .wrap(buildAwsValue())
}
object DescribeHyperParameterTuningJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DescribeHyperParameterTuningJobResponse =
      zio.aws.sagemaker.model.DescribeHyperParameterTuningJobResponse(
        hyperParameterTuningJobName,
        hyperParameterTuningJobArn,
        hyperParameterTuningJobConfig.asEditable,
        trainingJobDefinition.map(value => value.asEditable),
        trainingJobDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hyperParameterTuningJobStatus,
        creationTime,
        hyperParameterTuningEndTime.map(value => value),
        lastModifiedTime.map(value => value),
        trainingJobStatusCounters.asEditable,
        objectiveStatusCounters.asEditable,
        bestTrainingJob.map(value => value.asEditable),
        overallBestTrainingJob.map(value => value.asEditable),
        warmStartConfig.map(value => value.asEditable),
        failureReason.map(value => value)
      )
    def hyperParameterTuningJobName: HyperParameterTuningJobName
    def hyperParameterTuningJobArn: HyperParameterTuningJobArn
    def hyperParameterTuningJobConfig
        : zio.aws.sagemaker.model.HyperParameterTuningJobConfig.ReadOnly
    def trainingJobDefinition: Optional[
      zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly
    ]
    def trainingJobDefinitions: Optional[
      List[zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly]
    ]
    def hyperParameterTuningJobStatus
        : zio.aws.sagemaker.model.HyperParameterTuningJobStatus
    def creationTime: Timestamp
    def hyperParameterTuningEndTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def trainingJobStatusCounters
        : zio.aws.sagemaker.model.TrainingJobStatusCounters.ReadOnly
    def objectiveStatusCounters
        : zio.aws.sagemaker.model.ObjectiveStatusCounters.ReadOnly
    def bestTrainingJob: Optional[
      zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.ReadOnly
    ]
    def overallBestTrainingJob: Optional[
      zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.ReadOnly
    ]
    def warmStartConfig: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig.ReadOnly
    ]
    def failureReason: Optional[FailureReason]
    def getHyperParameterTuningJobName
        : ZIO[Any, Nothing, HyperParameterTuningJobName] =
      ZIO.succeed(hyperParameterTuningJobName)
    def getHyperParameterTuningJobArn
        : ZIO[Any, Nothing, HyperParameterTuningJobArn] =
      ZIO.succeed(hyperParameterTuningJobArn)
    def getHyperParameterTuningJobConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.HyperParameterTuningJobConfig.ReadOnly
    ] = ZIO.succeed(hyperParameterTuningJobConfig)
    def getTrainingJobDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly
    ] =
      AwsError.unwrapOptionField("trainingJobDefinition", trainingJobDefinition)
    def getTrainingJobDefinitions: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "trainingJobDefinitions",
      trainingJobDefinitions
    )
    def getHyperParameterTuningJobStatus: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.HyperParameterTuningJobStatus
    ] = ZIO.succeed(hyperParameterTuningJobStatus)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getHyperParameterTuningEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "hyperParameterTuningEndTime",
        hyperParameterTuningEndTime
      )
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getTrainingJobStatusCounters: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.TrainingJobStatusCounters.ReadOnly
    ] = ZIO.succeed(trainingJobStatusCounters)
    def getObjectiveStatusCounters: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ObjectiveStatusCounters.ReadOnly
    ] = ZIO.succeed(objectiveStatusCounters)
    def getBestTrainingJob: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.ReadOnly
    ] = AwsError.unwrapOptionField("bestTrainingJob", bestTrainingJob)
    def getOverallBestTrainingJob: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "overallBestTrainingJob",
      overallBestTrainingJob
    )
    def getWarmStartConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig.ReadOnly
    ] = AwsError.unwrapOptionField("warmStartConfig", warmStartConfig)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobResponse
  ) extends zio.aws.sagemaker.model.DescribeHyperParameterTuningJobResponse.ReadOnly {
    override val hyperParameterTuningJobName: HyperParameterTuningJobName =
      zio.aws.sagemaker.model.primitives
        .HyperParameterTuningJobName(impl.hyperParameterTuningJobName())
    override val hyperParameterTuningJobArn: HyperParameterTuningJobArn =
      zio.aws.sagemaker.model.primitives
        .HyperParameterTuningJobArn(impl.hyperParameterTuningJobArn())
    override val hyperParameterTuningJobConfig
        : zio.aws.sagemaker.model.HyperParameterTuningJobConfig.ReadOnly =
      zio.aws.sagemaker.model.HyperParameterTuningJobConfig
        .wrap(impl.hyperParameterTuningJobConfig())
    override val trainingJobDefinition: Optional[
      zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.trainingJobDefinition())
      .map(value =>
        zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.wrap(value)
      )
    override val trainingJobDefinitions: Optional[
      List[zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.trainingJobDefinitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.wrap(item)
        }.toList
      )
    override val hyperParameterTuningJobStatus
        : zio.aws.sagemaker.model.HyperParameterTuningJobStatus =
      zio.aws.sagemaker.model.HyperParameterTuningJobStatus
        .wrap(impl.hyperParameterTuningJobStatus())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val hyperParameterTuningEndTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hyperParameterTuningEndTime())
        .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val trainingJobStatusCounters
        : zio.aws.sagemaker.model.TrainingJobStatusCounters.ReadOnly =
      zio.aws.sagemaker.model.TrainingJobStatusCounters
        .wrap(impl.trainingJobStatusCounters())
    override val objectiveStatusCounters
        : zio.aws.sagemaker.model.ObjectiveStatusCounters.ReadOnly =
      zio.aws.sagemaker.model.ObjectiveStatusCounters
        .wrap(impl.objectiveStatusCounters())
    override val bestTrainingJob: Optional[
      zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bestTrainingJob())
      .map(value =>
        zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.wrap(value)
      )
    override val overallBestTrainingJob: Optional[
      zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.overallBestTrainingJob())
      .map(value =>
        zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.wrap(value)
      )
    override val warmStartConfig: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.warmStartConfig())
      .map(value =>
        zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig
          .wrap(value)
      )
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobResponse
  ): zio.aws.sagemaker.model.DescribeHyperParameterTuningJobResponse.ReadOnly =
    new Wrapper(impl)
}
