package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.MonitoringJobDefinitionName
import scala.jdk.CollectionConverters._
final case class DeleteModelExplainabilityJobDefinitionRequest(
    jobDefinitionName: MonitoringJobDefinitionName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteModelExplainabilityJobDefinitionRequest = {
    import DeleteModelExplainabilityJobDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteModelExplainabilityJobDefinitionRequest
      .builder()
      .jobDefinitionName(
        MonitoringJobDefinitionName.unwrap(jobDefinitionName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DeleteModelExplainabilityJobDefinitionRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteModelExplainabilityJobDefinitionRequest
      .wrap(buildAwsValue())
}
object DeleteModelExplainabilityJobDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteModelExplainabilityJobDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DeleteModelExplainabilityJobDefinitionRequest =
      zio.aws.sagemaker.model
        .DeleteModelExplainabilityJobDefinitionRequest(jobDefinitionName)
    def jobDefinitionName: MonitoringJobDefinitionName
    def getJobDefinitionName: ZIO[Any, Nothing, MonitoringJobDefinitionName] =
      ZIO.succeed(jobDefinitionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteModelExplainabilityJobDefinitionRequest
  ) extends zio.aws.sagemaker.model.DeleteModelExplainabilityJobDefinitionRequest.ReadOnly {
    override val jobDefinitionName: MonitoringJobDefinitionName =
      zio.aws.sagemaker.model.primitives
        .MonitoringJobDefinitionName(impl.jobDefinitionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteModelExplainabilityJobDefinitionRequest
  ): zio.aws.sagemaker.model.DeleteModelExplainabilityJobDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
